/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.artix.ds;

import biz.c24.io.api.data.ComplexDataObject;
import biz.c24.io.api.presentation.BinarySink;
import biz.c24.io.api.presentation.JavaClassSink;
import biz.c24.io.api.presentation.SAXSink;
import biz.c24.io.api.presentation.Sink;
import biz.c24.io.api.presentation.TagValuePairSink;
import biz.c24.io.api.presentation.TextualSink;
import biz.c24.io.api.presentation.XMLSink;
import biz.c24.io.api.presentation.swift.SwiftPreParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.model.dataformat.ArtixDSContentType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class SwiftFormat
implements DataFormat {
    private final SwiftPreParser swiftParser;
    private Sink sink;
    private ArtixDSContentType contentType;

    public SwiftFormat() {
        this(new SwiftPreParser());
    }

    public SwiftFormat(SwiftPreParser swiftParser) {
        this.swiftParser = swiftParser;
    }

    public SwiftFormat(SwiftPreParser swiftParser, Sink sink) {
        this(swiftParser);
        this.sink = sink;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ComplexDataObject dataObject = ExchangeHelper.convertToMandatoryType(exchange, ComplexDataObject.class, graph);
        Sink s = this.getSink(exchange);
        ObjectHelper.notNull(s, "sink or element");
        s.setOutputStream(stream);
        s.writeObject(dataObject);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        this.swiftParser.setInputStream(stream);
        return this.swiftParser.readObject();
    }

    public Sink getSink(Exchange exchange) {
        if (this.sink == null) {
            ArtixDSContentType content = this.getContentType();
            if (content != null) {
                this.sink = this.createSink(content);
            }
            if (this.sink == null) {
                this.sink = this.createDefaultSink();
            }
        }
        return this.sink;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public ArtixDSContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ArtixDSContentType contentType) {
        this.contentType = contentType;
    }

    protected Sink createSink(ArtixDSContentType content) {
        switch (content) {
            case Default: {
                return this.createDefaultSink();
            }
            case Binary: {
                return new BinarySink();
            }
            case Java: {
                return new JavaClassSink();
            }
            case Sax: {
                return new SAXSink();
            }
            case Text: {
                return new TextualSink();
            }
            case Xml: {
                return new XMLSink();
            }
            case TagValuePair: {
                return new TagValuePairSink();
            }
        }
        throw new IllegalArgumentException("Unknown format type: " + (Object)((Object)content));
    }

    protected Sink createDefaultSink() {
        return new TextualSink();
    }
}

