/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam;

import java.util.Date;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.bam.ActivityLifecycle;
import org.apache.camel.bam.ProcessBuilder;
import org.apache.camel.bam.TimeExpression;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.camel.builder.ProcessorFactory;
import org.apache.camel.impl.EventDrivenConsumerRoute;

public class ActivityBuilder
implements ProcessorFactory {
    private ProcessBuilder processBuilder;
    private Endpoint endpoint;
    private ActivityRules activityRules;
    private Expression correlationExpression;

    public ActivityBuilder(ProcessBuilder processBuilder, Endpoint endpoint) {
        this.processBuilder = processBuilder;
        this.endpoint = endpoint;
        this.activityRules = new ActivityRules(processBuilder);
        this.activityRules.setActivityName(endpoint.getEndpointUri());
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Processor createProcessor() throws Exception {
        return this.processBuilder.createActivityProcessor(this);
    }

    public Route createRoute() throws Exception {
        Processor processor = this.createProcessor();
        if (processor == null) {
            throw new IllegalArgumentException("No processor created for ActivityBuilder: " + this);
        }
        return new EventDrivenConsumerRoute(this.getEndpoint(), processor);
    }

    public ActivityBuilder correlate(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
        return this;
    }

    public ActivityBuilder name(String name) {
        this.activityRules.setActivityName(name);
        return this;
    }

    public TimeExpression starts() {
        return new TimeExpression(this, ActivityLifecycle.Started){

            public Date evaluate(ProcessInstance instance, ActivityState state) {
                return state.getTimeStarted();
            }
        };
    }

    public TimeExpression completes() {
        return new TimeExpression(this, ActivityLifecycle.Completed){

            public Date evaluate(ProcessInstance instance, ActivityState state) {
                return state.getTimeCompleted();
            }
        };
    }

    public Expression getCorrelationExpression() {
        return this.correlationExpression;
    }

    public ActivityRules getActivityRules() {
        return this.activityRules;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }
}

