/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.util.Date;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.component.atom.EntryFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatedDateFilter
implements EntryFilter {
    private static final transient Log LOG = LogFactory.getLog(UpdatedDateFilter.class);
    private Date lastUpdate;

    public UpdatedDateFilter(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean isValidEntry(AtomEndpoint endpoint, Document<Feed> feed, Entry entry) {
        Date updated = entry.getUpdated();
        if (updated == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No updated time for entry so assuming its valid: entry=[" + entry + "]"));
            }
            return true;
        }
        if (this.lastUpdate != null && this.lastUpdate.after(updated)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Entry is older than lastupdate=[" + this.lastUpdate + "], no valid entry=[" + entry + "]"));
            }
            return false;
        }
        this.lastUpdate = updated;
        return true;
    }
}

