/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.AsyncProcessorDecorator;
import org.apache.camel.component.cxf.CxfSoapBinding;
import org.apache.camel.component.cxf.CxfSoapEndpoint;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.component.cxf.util.Dummy;
import org.apache.camel.component.cxf.util.NullConduit;
import org.apache.camel.component.cxf.util.NullConduitSelector;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;

public class CxfSoapProducer
implements Producer,
AsyncProcessor {
    private static final Log LOG = LogFactory.getLog(CxfSoapProducer.class);
    private final CxfSoapEndpoint endpoint;
    private final Producer producer;
    private final AsyncProcessor processor;
    private ClientImpl client;

    public CxfSoapProducer(CxfSoapEndpoint endpoint) throws Exception {
        this.endpoint = endpoint;
        this.producer = endpoint.getInnerEndpoint().createProducer();
        this.processor = new AsyncProcessorDecorator(this.producer, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapProducer.this.processSoapProviderIn(exchange);
            }
        }, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapProducer.this.processSoapProviderOut(exchange);
            }
        });
        Class sei = null;
        if (ObjectHelper.isNotEmpty(endpoint.getServiceClass())) {
            sei = ClassLoaderUtils.loadClass((String)endpoint.getServiceClass(), this.getClass());
        }
        ClientProxyFactoryBean cfb = CxfEndpointUtils.getClientFactoryBean(sei);
        if (sei == null) {
            cfb.setServiceClass(Dummy.class);
        } else {
            cfb.setServiceClass(sei);
        }
        cfb.setWsdlURL(endpoint.getWsdl().getURL().toString());
        if (endpoint.getServiceName() != null) {
            cfb.setServiceName(endpoint.getServiceName());
        }
        if (endpoint.getEndpointName() != null) {
            cfb.setEndpointName(endpoint.getEndpointName());
        }
        cfb.setConduitSelector((ConduitSelector)new NullConduitSelector());
        this.client = (ClientImpl)((ClientProxy)Proxy.getInvocationHandler(cfb.create())).getClient();
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.producer.createExchange(pattern);
    }

    public Exchange createExchange(Exchange exchange) {
        return this.producer.createExchange(exchange);
    }

    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    public void start() throws Exception {
        this.producer.start();
    }

    public void stop() throws Exception {
        this.producer.stop();
    }

    protected void processSoapProviderOut(Exchange exchange) throws Exception {
        LOG.info((Object)("processSoapProviderOut: " + exchange));
        Message inMessage = CxfSoapBinding.getCxfInMessage(this.endpoint.getHeaderFilterStrategy(), exchange, true);
        this.client.setInInterceptors(this.client.getEndpoint().getService().getInInterceptors());
        this.client.onMessage(inMessage);
        exchange.getOut().setBody(inMessage.getContent(Source.class));
        exchange.getOut().setHeaders((Map<String, Object>)inMessage);
    }

    protected Bus getBus() {
        return this.endpoint.getBus();
    }

    protected void processSoapProviderIn(Exchange exchange) throws Exception {
        LOG.info((Object)("processSoapProviderIn: " + exchange));
        org.apache.cxf.endpoint.Endpoint cxfEndpoint = this.client.getEndpoint();
        ExchangeImpl cxfExchange = new ExchangeImpl();
        cxfExchange.put(org.apache.cxf.endpoint.Endpoint.class, (Object)cxfEndpoint);
        cxfExchange.put(Bus.class, (Object)this.getBus());
        cxfExchange.setConduit((Conduit)new NullConduit());
        exchange.setProperty("org.apache.cxf.message.exchange", cxfExchange);
        Message outMessage = CxfSoapBinding.getCxfOutMessage(this.endpoint.getHeaderFilterStrategy(), exchange, true);
        outMessage.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        outMessage.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        InterceptorChain chain = OutgoingChainInterceptor.getOutInterceptorChain((org.apache.cxf.message.Exchange)cxfExchange);
        outMessage.setInterceptorChain(chain);
        chain.doIntercept(outMessage);
        CachedOutputStream outputStream = (CachedOutputStream)outMessage.getContent(OutputStream.class);
        exchange.getOut().setBody(outputStream.getInputStream());
        exchange.getIn().setBody(outputStream.getInputStream());
    }
}

