/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.concurrent.Executor;
import org.apache.camel.component.cxf.MessageInvoker;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageInvokerInterceptor
extends AbstractPhaseInterceptor<Message> {
    public MessageInvokerInterceptor() {
        super("invoke");
    }

    public void handleMessage(final Message message) {
        final Exchange exchange = message.getExchange();
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        Service service = endpoint.getService();
        final MessageInvoker invoker = (MessageInvoker)service.getInvoker();
        Runnable invocation = new Runnable(){

            public void run() {
                Exchange runableEx = message.getExchange();
                invoker.invoke(runableEx);
                if (!exchange.isOneWay()) {
                    Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
                    Message outMessage = runableEx.getOutMessage();
                    MessageInvokerInterceptor.this.copyJaxwsProperties(message, outMessage);
                    if (outMessage == null) {
                        outMessage = ep.getBinding().createMessage();
                        exchange.setOutMessage(outMessage);
                    }
                }
            }
        };
        Executor executor = this.getExecutor(endpoint);
        if (exchange.get(Executor.class) == executor) {
            invocation.run();
        } else {
            exchange.put(Executor.class, (Object)executor);
            executor.execute(invocation);
        }
    }

    private Executor getExecutor(Endpoint endpoint) {
        return endpoint.getService().getExecutor();
    }

    private void copyJaxwsProperties(Message inMsg, Message outMsg) {
        outMsg.put((Object)"javax.xml.ws.wsdl.operation", inMsg.get((Object)"javax.xml.ws.wsdl.operation"));
        outMsg.put((Object)"javax.xml.ws.wsdl.service", inMsg.get((Object)"javax.xml.ws.wsdl.service"));
        outMsg.put((Object)"javax.xml.ws.wsdl.interface", inMsg.get((Object)"javax.xml.ws.wsdl.interface"));
        outMsg.put((Object)"javax.xml.ws.wsdl.port", inMsg.get((Object)"javax.xml.ws.wsdl.port"));
        outMsg.put((Object)"javax.xml.ws.wsdl.description", inMsg.get((Object)"javax.xml.ws.wsdl.description"));
    }
}

