/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.interceptors.AbstractMessageOutInterceptor;
import org.apache.camel.component.cxf.interceptors.DOMOutInterceptor;
import org.apache.cxf.bindings.xformat.XMLBindingMessageFormat;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMessageOutInterceptor
extends AbstractMessageOutInterceptor<XMLMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLMessageOutInterceptor.class);

    public XMLMessageOutInterceptor() {
        super("prepare-send");
        this.addAfter(DOMOutInterceptor.class.getName());
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public void handleMessage(XMLMessage message) throws Fault {
        Exchange exchange = message.getExchange();
        BindingMessageInfo bmi = (BindingMessageInfo)exchange.get(BindingMessageInfo.class);
        ArrayList<Element> payload = (ArrayList<Element>)message.get(List.class);
        if (bmi == null && payload.size() > 1) {
            throw new Fault(new Message("NO_XML_ROOT_NODE", LOG, new Object[0]));
        }
        if (bmi != null) {
            XMLBindingMessageFormat msgFormat;
            QName rootName;
            Element header = (Element)message.get(Element.class);
            if (header != null) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("DOMOutInterceptor Copy Message Part related Headers to Payload.");
                }
                this.moveHeaderPartToPayload(bmi, header, (List<Element>)payload);
            }
            QName qName = rootName = (msgFormat = (XMLBindingMessageFormat)bmi.getExtensor(XMLBindingMessageFormat.class)) != null ? msgFormat.getRootNode() : null;
            if (rootName == null) {
                if (payload.size() > 1) {
                    throw new Fault(new Message("NO_XML_ROOT_NODE", LOG, new Object[0]));
                }
            } else {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("DOMOutInterceptor Create xmlformat RootNode element");
                }
                Element el = this.createElement(rootName, (List<Element>)payload);
                payload = new ArrayList<Element>();
                payload.add(el);
            }
            message.put(List.class, (Object)payload);
            message.remove(Element.class);
        }
    }

    private void moveHeaderPartToPayload(BindingMessageInfo bmi, Element header, List<Element> payload) {
        List bodyParts = bmi.getMessageParts();
        NodeList nodes = header.getChildNodes();
        block0: for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Node node = nodes.item(idx);
            int index = 0;
            for (MessagePartInfo mpi : bodyParts) {
                QName name = mpi.getConcreteName();
                if (name.getLocalPart().equals(node.getLocalName()) && name.getNamespaceURI().equals(node.getNamespaceURI())) {
                    payload.add(index, (Element)node);
                    continue block0;
                }
                ++index;
            }
        }
    }
}

