/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfClient
extends ClientImpl {
    private static final Logger LOG = LogUtils.getL7dLogger(CxfClient.class);

    public CxfClient(Bus b, Endpoint e) {
        super(b, e);
    }

    public Object dispatch(Map<Class, Object> params, Map<String, Object> context, Exchange exchange) throws Exception {
        BindingInfo bi;
        Object retval = null;
        InvokingContext invokingContext = (InvokingContext)exchange.get(InvokingContext.class);
        ObjectHelper.notNull(invokingContext, "invokingContext");
        BindingOperationInfo inBoundOp = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        BindingOperationInfo outBoundOp = null;
        if (inBoundOp != null && (outBoundOp = (bi = this.getEndpoint().getEndpointInfo().getBinding()).getOperation(inBoundOp.getOperationInfo().getName())) != null && inBoundOp.isUnwrapped()) {
            outBoundOp = outBoundOp.getUnwrappedOperation();
        }
        retval = this.invokeWithMessageStream(outBoundOp, params, context, invokingContext);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeWithMessageStream(BindingOperationInfo bi, Map<Class, Object> param, Map<String, Object> context, InvokingContext invokingContext) throws Exception {
        Object retval = null;
        Map requestContext = null;
        Map responseContext = null;
        if (null != context) {
            requestContext = (Map)context.get("RequestContext");
            responseContext = (Map)context.get("ResponseContext");
        }
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.put(InvokingContext.class, (Object)invokingContext);
        if (bi != null) {
            exchange.put(BindingMessageInfo.class, (Object)bi.getInput());
            exchange.setOneWay(bi.getOperationInfo().isOneWay());
        }
        Message message = this.prepareMessage((Exchange)exchange, requestContext, param, invokingContext);
        message.put((Object)"org.apache.cxf.invocation.context", context);
        Endpoint ep = this.getEndpoint();
        if (ep != null) {
            message.putAll((Map)ep);
        }
        this.setExchangeProperties((Exchange)exchange, ep, bi);
        PhaseInterceptorChain chain = this.setupInterceptorChain(this.getEndpoint());
        message.setInterceptorChain((InterceptorChain)chain);
        this.modifyChain((InterceptorChain)chain, requestContext);
        chain.setFaultObserver((MessageObserver)this.outFaultObserver);
        this.prepareConduitSelector(message);
        this.modifyChain((InterceptorChain)chain, null);
        chain.doIntercept(message);
        Exception ex = (Exception)message.getContent(Exception.class);
        if (ex != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Exception in outgoing chain: " + ex.toString());
            }
            throw ex;
        }
        if (!exchange.isOneWay()) {
            ExchangeImpl exchangeImpl = exchange;
            synchronized (exchangeImpl) {
                this.waitResponse((Exchange)exchange);
            }
            ex = this.getException((Exchange)exchange);
            if (ex != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Exception in incoming chain: " + ex.toString());
                }
                throw ex;
            }
            retval = invokingContext.getResponseObject((Exchange)exchange, responseContext);
        }
        return retval;
    }

    protected void waitResponse(Exchange exchange) {
        long start;
        long end;
        for (int remaining = this.synchronousTimeout; !Boolean.TRUE.equals(exchange.get((Object)"exchange.finished")) && remaining > 0; remaining -= (int)(end - start)) {
            start = System.currentTimeMillis();
            try {
                exchange.wait(remaining);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            end = System.currentTimeMillis();
        }
        if (!Boolean.TRUE.equals(exchange.get((Object)"exchange.finished"))) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"RESPONSE_TIMEOUT", (Object)((OperationInfo)exchange.get(OperationInfo.class)).getName().toString());
        }
    }

    private Message prepareMessage(Exchange exchange, Map<String, Object> requestContext, Map<Class, Object> param, InvokingContext invokingContext) {
        Message message = this.getEndpoint().getBinding().createMessage();
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        if (requestContext != null) {
            message.putAll(requestContext);
        }
        if (param != null) {
            invokingContext.setRequestOutMessageContent(message, param);
        }
        if (null != requestContext) {
            exchange.putAll(requestContext);
        }
        exchange.setOutMessage(message);
        return message;
    }
}

