/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.invoker.AbstractInvokingContext;
import org.apache.camel.component.cxf.invoker.PayloadMessage;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadInvokingContext
extends AbstractInvokingContext {
    private static final Logger LOG = LogUtils.getL7dLogger(PayloadInvokingContext.class);

    @Override
    public void setRequestOutMessageContent(Message message, Map<Class, Object> contents) {
        PayloadMessage request = (PayloadMessage)contents.get(PayloadMessage.class);
        List<SoapHeader> headers = request.getHeaders();
        List<Element> payload = request.getPayload();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("header = " + headers + ", paylaod = " + payload);
        }
        message.put((Object)Header.HEADER_LIST, headers);
        message.put(List.class, payload);
    }

    @Override
    public Object getResponseObject(Exchange exchange, Map<String, Object> responseContext) {
        PayloadMessage payloadMsg = null;
        Message msg = exchange.getInMessage();
        List payload = this.getResponseObject(msg, responseContext, List.class);
        List header = CastUtils.cast((List)((List)exchange.getInMessage().get((Object)Header.HEADER_LIST)));
        payloadMsg = new PayloadMessage(payload, header);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(payloadMsg.toString());
        }
        return payloadMsg;
    }

    @Override
    protected <T> T getResponseObject(Message inMessage, Map<String, Object> responseContext, Class<T> clazz) {
        Object retval = null;
        if (inMessage != null) {
            if (null != responseContext) {
                responseContext.putAll((Map<String, Object>)inMessage);
                LOG.info("set responseContext to be" + responseContext);
            }
            retval = inMessage.get(clazz);
        }
        return (T)retval;
    }

    @Override
    public void setResponseContent(Message outMessage, Object resultPayload) {
        if (resultPayload != null) {
            PayloadMessage payloadMessage = (PayloadMessage)resultPayload;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(payloadMessage.toString());
            }
            outMessage.put(List.class, payloadMessage.getPayload());
            outMessage.put((Object)Header.HEADER_LIST, payloadMessage.getHeaders());
        }
    }

    @Override
    public Map<Class, Object> getRequestContent(Message inMessage) {
        List payload = (List)inMessage.get(List.class);
        List headers = CastUtils.cast((List)((List)inMessage.get((Object)Header.HEADER_LIST)));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Header = " + headers + ", Payload = " + payload);
        }
        IdentityHashMap<Class, Object> contents = new IdentityHashMap<Class, Object>();
        contents.put(PayloadMessage.class, new PayloadMessage(payload, headers));
        return contents;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

