/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.simple.FileLanguage;
import org.apache.commons.net.ftp.FTPClientConfig;

public class RemoteFileConfiguration
implements Cloneable {
    private String protocol;
    private String username;
    private String host;
    private int port;
    private String password;
    private String file;
    private boolean binary;
    private boolean directory = true;
    private FTPClientConfig ftpClientConfig;
    private Expression expression;
    private boolean passiveMode;
    private String knownHosts;
    private String privateKeyFile;
    private String privateKeyFilePassphrase;

    public RemoteFileConfiguration() {
    }

    public RemoteFileConfiguration(URI uri) {
        this.configure(uri);
    }

    public RemoteFileConfiguration copy() {
        try {
            return (RemoteFileConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public String toString() {
        return this.remoteServerInformation() + "/" + this.file;
    }

    public String remoteServerInformation() {
        return this.protocol + "://" + (this.username != null ? this.username : "anonymous") + "@" + this.host + ":" + this.port;
    }

    public void configure(URI uri) {
        this.setProtocol(uri.getScheme());
        this.setDefaultPort();
        this.setUsername(uri.getUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.setFile(uri.getPath());
    }

    protected void setDefaultPort() {
        if ("ftp".equalsIgnoreCase(this.protocol)) {
            this.setPort(21);
        } else if ("sftp".equalsIgnoreCase(this.protocol)) {
            this.setPort(22);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        this.file = file;
    }

    public String getKnownHosts() {
        return this.knownHosts;
    }

    public void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port != -1) {
            this.port = port;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public FTPClientConfig getFtpClientConfig() {
        return this.ftpClientConfig;
    }

    public void setFtpClientConfig(FTPClientConfig ftpClientConfig) {
        this.ftpClientConfig = ftpClientConfig;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setExpression(String fileLanguageExpression) {
        this.expression = FileLanguage.file(fileLanguageExpression);
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getPrivateKeyFilePassphrase() {
        return this.privateKeyFilePassphrase;
    }

    public void setPrivateKeyFilePassphrase(String privateKeyFilePassphrase) {
        this.privateKeyFilePassphrase = privateKeyFilePassphrase;
    }
}

