/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.OutputStream;
import java.util.Map;
import org.apache.camel.component.file.remote.RemoteFileBinding;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.impl.DefaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileMessage
extends DefaultMessage {
    private OutputStream outputStream;
    private String fullFileName;
    private String fileName;
    private String hostname;
    private long fileLength;

    public RemoteFileMessage() {
    }

    public RemoteFileMessage(String hostname, String fullFileName, String fileName, long fileLength, OutputStream outputStream) {
        this.hostname = hostname;
        this.fullFileName = fullFileName;
        this.fileName = fileName;
        this.fileLength = fileLength;
        this.outputStream = outputStream;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public void setFullFileName(String fullFileName) {
        this.fullFileName = fullFileName;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public RemoteFileExchange getExchange() {
        return (RemoteFileExchange)super.getExchange();
    }

    @Override
    protected Object createBody() {
        if (this.outputStream != null) {
            return ((RemoteFileBinding)this.getExchange().getBinding()).extractBodyFromOutputStream(this.getExchange(), this.outputStream);
        }
        return null;
    }

    @Override
    public RemoteFileMessage newInstance() {
        return new RemoteFileMessage();
    }

    @Override
    protected void populateInitialHeaders(Map<String, Object> map) {
        super.populateInitialHeaders(map);
        map.put("file.remote.host", this.hostname);
        map.put("file.remote.fullName", this.fullFileName);
        map.put("file.remote.name", this.fileName);
        map.put("CamelFileName", this.fileName);
        map.put("CamelFilePath", this.fullFileName);
        if (this.fullFileName != null && this.fullFileName.indexOf("/") != -1) {
            String parent = this.fullFileName.substring(0, this.fullFileName.lastIndexOf("/"));
            map.put("CamelFileParent", parent);
        }
        if (this.fileLength > 0L) {
            map.put("CamelFileLength", new Long(this.fileLength));
        }
    }
}

