/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.IOException;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.strategy.FileProcessStrategySupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteFileProcessStrategy
extends FileProcessStrategySupport {
    private static final transient Log LOG = LogFactory.getLog(DeleteFileProcessStrategy.class);

    public DeleteFileProcessStrategy() {
    }

    public DeleteFileProcessStrategy(boolean lockFile) {
        super(lockFile);
    }

    public void commit(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        boolean deleted;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting file: " + file));
        }
        if (!(deleted = file.delete())) {
            throw new IOException("Can not delete file: " + file);
        }
        super.commit(endpoint, exchange, file);
    }
}

