/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.IOException;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.strategy.DefaultFileRenamer;
import org.apache.camel.component.file.strategy.FileProcessStrategySupport;
import org.apache.camel.component.file.strategy.FileRenamer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenameFileProcessStrategy
extends FileProcessStrategySupport {
    private static final transient Log LOG = LogFactory.getLog(RenameFileProcessStrategy.class);
    private FileRenamer beginRenamer;
    private FileRenamer commitRenamer;

    public RenameFileProcessStrategy() {
        this(true);
    }

    public RenameFileProcessStrategy(boolean lock) {
        this(lock, ".camel/", "");
    }

    public RenameFileProcessStrategy(boolean lock, String namePrefix, String namePostfix) {
        this(lock, new DefaultFileRenamer(namePrefix, namePostfix), null);
    }

    public RenameFileProcessStrategy(boolean lock, String namePrefix, String namePostfix, String preNamePrefix, String preNamePostfix) {
        this(lock, new DefaultFileRenamer(namePrefix, namePostfix), new DefaultFileRenamer(preNamePrefix, preNamePostfix));
    }

    public RenameFileProcessStrategy(boolean lock, FileRenamer commitRenamer, FileRenamer beginRenamer) {
        super(lock);
        this.commitRenamer = commitRenamer;
        this.beginRenamer = beginRenamer;
    }

    public boolean begin(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        boolean answer = super.begin(endpoint, exchange, file);
        if (this.beginRenamer != null) {
            File newName = this.beginRenamer.renameFile(exchange, file);
            File to2 = RenameFileProcessStrategy.renameFile(file, newName);
            exchange.setFile(to2);
        }
        return answer;
    }

    public void commit(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        File newName = this.commitRenamer.renameFile(exchange, file);
        RenameFileProcessStrategy.renameFile(file, newName);
        super.commit(endpoint, exchange, file);
    }

    private static File renameFile(File from, File to2) throws IOException {
        boolean renamed;
        File parent;
        if (to2.exists()) {
            to2.delete();
        }
        if (!(parent = to2.getParentFile()).exists()) {
            boolean mkdir;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating directory: " + parent));
            }
            if (!(mkdir = parent.mkdirs())) {
                throw new IOException("Can not create directory: " + parent);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming file: " + from + " to: " + to2));
        }
        if (!(renamed = from.renameTo(to2))) {
            throw new IOException("Can not rename file from: " + from + " to: " + to2);
        }
        return to2;
    }

    public FileRenamer getBeginRenamer() {
        return this.beginRenamer;
    }

    public void setBeginRenamer(FileRenamer beginRenamer) {
        this.beginRenamer = beginRenamer;
    }

    public FileRenamer getCommitRenamer() {
        return this.commitRenamer;
    }

    public void setCommitRenamer(FileRenamer commitRenamer) {
        this.commitRenamer = commitRenamer;
    }
}

