/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.spi.HeaderFilterStrategy;

public class DefaultHttpBinding
implements HttpBinding {
    private boolean useReaderForPayload;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();

    public DefaultHttpBinding() {
    }

    public DefaultHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void readRequest(HttpServletRequest request, HttpMessage message) {
        message.getBody();
        message.getHeaders();
    }

    public void writeResponse(HttpExchange exchange, HttpServletResponse response) throws IOException {
        if (exchange.isFailed()) {
            Message fault = exchange.getFault(false);
            if (fault != null) {
                this.doWriteFaultResponse(fault, response);
            } else {
                this.doWriteExceptionResponse(exchange.getException(), response);
            }
        } else {
            this.copyProtocolHeaders(exchange.getIn(), exchange.getOut());
            Message out = exchange.getOut();
            if (out != null) {
                this.doWriteResponse(out, response);
            }
        }
    }

    private void copyProtocolHeaders(Message request, Message response) {
        if (request.getHeader("Content-Encoding") != null) {
            String contentEncoding = request.getHeader("Content-Encoding", String.class);
            response.setHeader("Content-Encoding", contentEncoding);
        }
    }

    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        response.setStatus(500);
        response.setContentType("text/plain");
        PrintWriter pw = response.getWriter();
        exception.printStackTrace(pw);
        pw.flush();
    }

    public void doWriteFaultResponse(Message message, HttpServletResponse response) throws IOException {
        this.doWriteResponse(message, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWriteResponse(Message message, HttpServletResponse response) throws IOException {
        if (message.getHeader("http.responseCode") != null) {
            int code = message.getHeader("http.responseCode", Integer.class);
            response.setStatus(code);
        }
        if (message.getHeader("Content-Type") != null) {
            String contentType = message.getHeader("Content-Type", String.class);
            response.setContentType(contentType);
        }
        for (String key : message.getHeaders().keySet()) {
            String value = message.getHeader(key, String.class);
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, value)) continue;
            response.setHeader(key, value);
        }
        if (message.getBody() != null) {
            InputStream is = message.getBody(InputStream.class);
            if (is != null) {
                ServletOutputStream os = response.getOutputStream();
                try {
                    int c;
                    ByteArrayOutputStream initialArray = new ByteArrayOutputStream();
                    while ((c = is.read()) >= 0) {
                        initialArray.write(c);
                    }
                    byte[] processedArray = this.processReponseContent(message, initialArray.toByteArray(), response);
                    os.write(processedArray);
                    response.setContentLength(processedArray.length);
                    os.flush();
                }
                finally {
                    os.close();
                    is.close();
                }
            } else {
                String data = message.getBody(String.class);
                if (data != null) {
                    response.setContentLength(data.length());
                    response.getWriter().print(data);
                    response.getWriter().flush();
                }
            }
        }
    }

    protected byte[] processReponseContent(Message message, byte[] array, HttpServletResponse response) throws IOException {
        String gzipEncoding = message.getHeader("Content-Encoding", String.class);
        return GZIPHelper.compressArrayIfGZIPRequested(gzipEncoding, array, response);
    }

    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        if ("GET".equals(request.getMethod())) {
            return null;
        }
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        return GZIPHelper.getInputStream(request);
    }

    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

