/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.helper;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public final class GZIPHelper {
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String GZIP = "gzip";

    private GZIPHelper() {
    }

    public static void setGZIPMessageHeader(Message message) {
        message.setHeader(CONTENT_ENCODING, GZIP);
    }

    public static void setGZIPContentEncoding(HttpServletResponse response) {
        response.setHeader(CONTENT_ENCODING, GZIP);
    }

    public static InputStream getInputStream(HttpMethod method) throws IOException {
        Header header = method.getRequestHeader(CONTENT_ENCODING);
        String contentEncoding = header != null ? header.getValue() : null;
        return GZIPHelper.getGZIPWrappedInputStream(contentEncoding, method.getResponseBodyAsStream());
    }

    public static InputStream getInputStream(HttpServletRequest request) throws IOException {
        ServletInputStream dataStream = request.getInputStream();
        String contentEncoding = request.getHeader(CONTENT_ENCODING);
        return GZIPHelper.getGZIPWrappedInputStream(contentEncoding, (InputStream)dataStream);
    }

    public static InputStream getGZIPWrappedInputStream(String gzipEncoding, InputStream inStream) throws IOException {
        if (GZIPHelper.containsGzip(gzipEncoding)) {
            return new GZIPInputStream(new BufferedInputStream(inStream));
        }
        return inStream;
    }

    public static InputStream toGZIPInputStreamIfRequested(String gzipEncoding, byte[] array) throws Exception {
        if (GZIPHelper.containsGzip(gzipEncoding)) {
            ByteArrayOutputStream outputByteArray = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputByteArray);
            gzipOutputStream.write(array);
            gzipOutputStream.close();
            return new ByteArrayInputStream(outputByteArray.toByteArray());
        }
        return new ByteArrayInputStream(array);
    }

    public static byte[] compressArrayIfGZIPRequested(String gzipEncoding, byte[] array) throws IOException {
        if (GZIPHelper.containsGzip(gzipEncoding)) {
            return GZIPHelper.getGZIPWrappedOutputStream(array).toByteArray();
        }
        return array;
    }

    public static byte[] compressArrayIfGZIPRequested(String gzipEncoding, byte[] array, HttpServletResponse response) throws IOException {
        if (GZIPHelper.containsGzip(gzipEncoding)) {
            return GZIPHelper.getGZIPWrappedOutputStream(array).toByteArray();
        }
        return array;
    }

    public static ByteArrayOutputStream getGZIPWrappedOutputStream(byte[] array) throws IOException {
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream(compressed);
        gzout.write(array);
        gzout.close();
        return compressed;
    }

    private static boolean containsGzip(String str) {
        return str != null && str.toLowerCase().indexOf(GZIP) >= 0;
    }
}

