/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.impl.PollingConsumerSupport;

public class IBatisPollingConsumer
extends PollingConsumerSupport {
    private final IBatisEndpoint endpoint;

    public IBatisPollingConsumer(IBatisEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public Exchange receive(long timeout) {
        return this.receiveNoWait();
    }

    public Exchange receive() {
        return this.receiveNoWait();
    }

    public Exchange receiveNoWait() {
        try {
            Object exchange = this.endpoint.createExchange();
            Message in = exchange.getIn();
            this.endpoint.query(in);
            return exchange;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to poll: " + this.endpoint + ". Reason: " + e, e);
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

