/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jcr.JcrComponent;
import org.apache.camel.component.jcr.JcrProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrEndpoint
extends DefaultEndpoint<DefaultExchange> {
    private Credentials credentials;
    private Repository repository;
    private String base;

    protected JcrEndpoint(String endpointUri, JcrComponent component) {
        super(endpointUri, component);
        try {
            URI uri = new URI(endpointUri);
            if (uri.getUserInfo() != null && uri.getAuthority() != null) {
                this.credentials = new SimpleCredentials(uri.getUserInfo(), uri.getAuthority().toCharArray());
            }
            this.repository = (Repository)component.getCamelContext().getRegistry().lookup(uri.getHost());
            if (this.repository == null) {
                throw new RuntimeCamelException("No JCR repository defined under '" + uri.getHost() + "'");
            }
            this.base = uri.getPath().replaceAll("^/", "");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + endpointUri, e);
        }
    }

    public JcrEndpoint(String endpointUri, String base, Credentials credentials, Repository repository) {
        super(endpointUri);
        this.base = base;
        this.credentials = credentials;
        this.repository = repository;
    }

    @Override
    public Consumer<DefaultExchange> createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("No consumer endpoint support for JCR available");
    }

    @Override
    public Producer<DefaultExchange> createProducer() throws Exception {
        return new JcrProducer(this);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    protected String getBase() {
        return this.base;
    }
}

