/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrProducer
extends DefaultProducer<DefaultExchange> {
    public JcrProducer(JcrEndpoint jcrEndpoint) throws LoginException, RepositoryException {
        super(jcrEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Session session = this.openSession();
        try {
            Node base = this.getBaseNode(session);
            Node node = base.addNode(this.getNodeName(exchange));
            TypeConverter converter = exchange.getContext().getTypeConverter();
            for (String key : exchange.getProperties().keySet()) {
                Value value = converter.convertTo(Value.class, exchange, exchange.getProperty(key));
                node.setProperty(key, value);
            }
            node.addMixin("mix:referenceable");
            session.save();
            exchange.getOut().setBody(node.getUUID());
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    private String getNodeName(Exchange exchange) {
        if (exchange.getProperty("org.apache.camel.component.jcr.node_name") != null) {
            return exchange.getProperty("org.apache.camel.component.jcr.node_name").toString();
        }
        return exchange.getExchangeId();
    }

    private Node getBaseNode(Session session) throws Exception {
        Node baseNode = session.getRootNode();
        for (String node : this.getJcrEndpoint().getBase().split("/")) {
            baseNode = baseNode.addNode(node);
        }
        return baseNode;
    }

    protected Session openSession() throws LoginException, RepositoryException {
        return this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials());
    }

    private JcrEndpoint getJcrEndpoint() {
        JcrEndpoint endpoint = (JcrEndpoint)this.getEndpoint();
        return endpoint;
    }
}

