/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.camel.ExchangePattern;
import org.apache.camel.HeaderFilterStrategyAware;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsPollingConsumer;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.component.jms.JmsProviderMetadata;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsEndpoint
extends DefaultEndpoint<JmsExchange> {
    private final boolean pubSubDomain;
    private JmsBinding binding;
    private String destination;
    private String selector;
    private JmsConfiguration configuration;
    private Requestor requestor;

    public JmsEndpoint(String uri, JmsComponent component, String destination, boolean pubSubDomain, JmsConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
        this.destination = destination;
        this.pubSubDomain = pubSubDomain;
    }

    public JmsEndpoint(String endpointUri, JmsBinding binding, JmsConfiguration configuration, String destination, boolean pubSubDomain) {
        super(endpointUri);
        this.binding = binding;
        this.configuration = configuration;
        this.destination = destination;
        this.pubSubDomain = pubSubDomain;
    }

    public JmsEndpoint(String endpointUri, String destination, boolean pubSubDomain) {
        this(endpointUri, new JmsBinding(), new JmsConfiguration(), destination, pubSubDomain);
    }

    public JmsEndpoint(String endpointUri, String destination) {
        this(endpointUri, destination, true);
    }

    public JmsProducer createProducer() throws Exception {
        return new JmsProducer(this);
    }

    public JmsProducer createProducer(JmsOperations template) throws Exception {
        JmsProducer answer = this.createProducer();
        if (template instanceof JmsTemplate) {
            JmsTemplate jmsTemplate = (JmsTemplate)template;
            jmsTemplate.setPubSubDomain(this.pubSubDomain);
            jmsTemplate.setDefaultDestinationName(this.destination);
        }
        answer.setInOnlyTemplate(template);
        return answer;
    }

    public JmsConsumer createConsumer(Processor processor) throws Exception {
        AbstractMessageListenerContainer listenerContainer = this.configuration.createMessageListenerContainer(this);
        return this.createConsumer(processor, listenerContainer);
    }

    public JmsConsumer createConsumer(Processor processor, AbstractMessageListenerContainer listenerContainer) throws Exception {
        listenerContainer.setDestinationName(this.destination);
        listenerContainer.setPubSubDomain(this.pubSubDomain);
        return new JmsConsumer(this, processor, listenerContainer);
    }

    @Override
    public PollingConsumer<JmsExchange> createPollingConsumer() throws Exception {
        JmsOperations template = this.createInOnlyTemplate();
        return new JmsPollingConsumer(this, template);
    }

    @Override
    public JmsExchange createExchange(ExchangePattern pattern) {
        return new JmsExchange(this.getCamelContext(), pattern, this.getBinding());
    }

    public JmsExchange createExchange(Message message) {
        return new JmsExchange(this.getCamelContext(), this.getExchangePattern(), this.getBinding(), message);
    }

    public JmsOperations createInOnlyTemplate() {
        return this.configuration.createInOnlyTemplate(this, this.pubSubDomain, this.destination);
    }

    public JmsOperations createInOutTemplate() {
        return this.configuration.createInOutTemplate(this, this.pubSubDomain, this.destination, this.getRequestTimeout());
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding(this);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public String getDestination() {
        return this.destination;
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public synchronized Requestor getRequestor() throws Exception {
        if (this.requestor == null) {
            this.requestor = new Requestor(this.getConfiguration(), this.getExecutorService());
            this.requestor.start();
        }
        return this.requestor;
    }

    public void setRequestor(Requestor requestor) {
        this.requestor = requestor;
    }

    public long getRequestTimeout() {
        return this.configuration.getRequestTimeout();
    }

    public void setRequestTimeout(long requestTimeout) {
        this.configuration.setRequestTimeout(requestTimeout);
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public Class<? extends TemporaryQueue> getTemporaryQueueType() {
        JmsProviderMetadata metadata = this.getProviderMetadata();
        JmsOperations template = this.getMetadataJmsOperations();
        return metadata.getTemporaryQueueType(template);
    }

    public Class<? extends TemporaryTopic> getTemporaryTopicType() {
        JmsOperations template = this.getMetadataJmsOperations();
        JmsProviderMetadata metadata = this.getProviderMetadata();
        return metadata.getTemporaryTopicType(template);
    }

    protected JmsProviderMetadata getProviderMetadata() {
        JmsConfiguration conf = this.getConfiguration();
        JmsProviderMetadata metadata = conf.getProviderMetadata();
        return metadata;
    }

    protected JmsOperations getMetadataJmsOperations() {
        JmsOperations template = this.getConfiguration().getMetadataJmsOperations(this);
        if (template == null) {
            throw new IllegalArgumentException("No Metadata JmsTemplate supplied!");
        }
        return template;
    }

    public void checkValidTemplate(JmsTemplate template) {
        if (template.getDestinationResolver() == null && this instanceof DestinationEndpoint) {
            DestinationEndpoint destinationEndpoint = (DestinationEndpoint)((Object)this);
            template.setDestinationResolver(JmsConfiguration.createDestinationResolver(destinationEndpoint));
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.getComponent() instanceof HeaderFilterStrategyAware) {
            return ((HeaderFilterStrategyAware)((Object)this.getComponent())).getHeaderFilterStrategy();
        }
        return new JmsHeaderFilterStrategy();
    }
}

