/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.JpaCallback;

public class DefaultTransactionStrategy
extends ServiceSupport
implements TransactionStrategy {
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;

    public DefaultTransactionStrategy(EntityManagerFactory entityManagerFactory) {
        ObjectHelper.notNull(entityManagerFactory, "entityManagerFactory");
        this.entityManagerFactory = entityManagerFactory;
    }

    public DefaultTransactionStrategy(EntityManager entityManager) {
        ObjectHelper.notNull(entityManager, "entityManager");
        this.entityManager = entityManager;
    }

    public Object execute(JpaCallback callback) {
        EntityManager em = this.getEntityManager();
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        try {
            Object answer = callback.doInJpa(em);
            transaction.commit();
            return answer;
        }
        catch (RuntimeException e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
    }

    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = this.entityManagerFactory.createEntityManager();
        }
        return this.entityManager;
    }

    protected void doStart() throws Exception {
        this.getEntityManager();
    }

    protected void doStop() throws Exception {
        if (this.entityManager != null) {
            this.entityManager.close();
        }
    }
}

