/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import javax.mail.Message;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConsumer;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.MailProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailEndpoint
extends ScheduledPollEndpoint<MailExchange> {
    private MailBinding binding;
    private MailConfiguration configuration;

    public MailEndpoint(String uri, MailComponent component, MailConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
        this.binding = new MailBinding(component.getHeaderFilterStrategy());
    }

    public MailEndpoint(String endpointUri, MailConfiguration configuration) {
        super(endpointUri);
        this.configuration = configuration;
    }

    public MailEndpoint(String endpointUri) {
        this(endpointUri, new MailConfiguration());
    }

    @Override
    public Producer<MailExchange> createProducer() throws Exception {
        JavaMailSenderImpl sender = this.configuration.createJavaMailSender();
        return this.createProducer((JavaMailSender)sender);
    }

    public Producer<MailExchange> createProducer(JavaMailSender sender) throws Exception {
        return new MailProducer(this, sender);
    }

    @Override
    public Consumer<MailExchange> createConsumer(Processor processor) throws Exception {
        if (this.configuration.getProtocol().startsWith("smtp")) {
            throw new IllegalArgumentException("Protocol " + this.configuration.getProtocol() + " can not be used for a MailConsumer. Please use another protocol such as pop3 or imap.");
        }
        JavaMailSenderImpl sender = this.configuration.createJavaMailSender();
        return this.createConsumer(processor, sender);
    }

    public Consumer<MailExchange> createConsumer(Processor processor, JavaMailSenderImpl sender) throws Exception {
        MailConsumer answer = new MailConsumer(this, processor, sender);
        answer.setDelay(60000L);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public MailExchange createExchange(ExchangePattern pattern) {
        return new MailExchange(this.getCamelContext(), pattern, this.getBinding());
    }

    public MailExchange createExchange(Message message) {
        return new MailExchange(this.getCamelContext(), this.getExchangePattern(), this.getBinding(), message);
    }

    public MailBinding getBinding() {
        if (this.binding == null) {
            this.binding = new MailBinding();
        }
        return this.binding;
    }

    public void setBinding(MailBinding binding) {
        this.binding = binding;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public MailConfiguration getConfiguration() {
        return this.configuration;
    }
}

