/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import org.apache.camel.Exchange;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Client;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class RestletProducer
extends DefaultProducer {
    private static final Log LOG = LogFactory.getLog(RestletProducer.class);
    private Client client;

    public RestletProducer(RestletEndpoint endpoint) throws Exception {
        super(endpoint);
        this.client = new Client(endpoint.getProtocol());
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client.start();
    }

    public void doStop() throws Exception {
        this.client.stop();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        String resourceUri = RestletProducer.buildUri(endpoint);
        Request request = new Request(endpoint.getRestletMethod(), resourceUri);
        RestletBinding binding = endpoint.getRestletBinding();
        binding.populateRestletRequestFromExchange(request, exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Client sends a request (method: " + request.getMethod() + ", uri: " + resourceUri + ")"));
        }
        Response response = this.client.handle(request);
        binding.populateExchangeFromRestletResponse(exchange, response);
    }

    private static String buildUri(RestletEndpoint endpoint) {
        return endpoint.getProtocol() + "://" + endpoint.getHost() + ":" + endpoint.getPort() + endpoint.getUriPattern();
    }
}

