/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.spring.integration.SpringIntegrationComponent;
import org.apache.camel.component.spring.integration.SpringIntegrationConsumer;
import org.apache.camel.component.spring.integration.SpringIntegrationExchange;
import org.apache.camel.component.spring.integration.SpringIntegrationProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.core.MessageChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringIntegrationEndpoint
extends ScheduledPollEndpoint<SpringIntegrationExchange> {
    private static final Log LOG = LogFactory.getLog(SpringIntegrationEndpoint.class);
    private String inputChannel;
    private String outputChannel;
    private String defaultChannel;
    private MessageChannel messageChannel;
    private boolean inOut;

    public SpringIntegrationEndpoint(String uri, String channel, SpringIntegrationComponent component) {
        super(uri, component);
        this.defaultChannel = channel;
    }

    public SpringIntegrationEndpoint(String uri, MessageChannel channel, CamelContext context) {
        super(uri, context);
        this.messageChannel = channel;
    }

    public SpringIntegrationEndpoint(String endpointUri, MessageChannel messageChannel) {
        super(endpointUri);
        this.messageChannel = messageChannel;
    }

    @Override
    public Producer<SpringIntegrationExchange> createProducer() throws Exception {
        return new SpringIntegrationProducer(this);
    }

    @Override
    public Consumer<SpringIntegrationExchange> createConsumer(Processor processor) throws Exception {
        return new SpringIntegrationConsumer(this, processor);
    }

    @Override
    public SpringIntegrationExchange createExchange() {
        return this.createExchange(this.getExchangePattern());
    }

    @Override
    public SpringIntegrationExchange createExchange(ExchangePattern pattern) {
        return new SpringIntegrationExchange(this.getCamelContext(), pattern);
    }

    public void setInputChannel(String input) {
        this.inputChannel = input;
    }

    public String getInputChannel() {
        return this.inputChannel;
    }

    public void setOutputChannel(String output) {
        this.outputChannel = output;
    }

    public String getOutputChannel() {
        return this.outputChannel;
    }

    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isInOut() {
        return this.inOut;
    }
}

