/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.adapter;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.SpringIntegrationExchange;
import org.apache.camel.component.spring.integration.adapter.AbstractCamelAdapter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.integration.message.MessageHandler;
import org.springframework.integration.message.MessageRejectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelTargetAdapter
extends AbstractCamelAdapter
implements MessageHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ProducerTemplate<Exchange> camelTemplate;
    private MessageChannel replyChannel;

    public void setReplyChannel(MessageChannel channel) {
        this.replyChannel = channel;
    }

    public MessageChannel getReplyChannel() {
        return this.replyChannel;
    }

    public ProducerTemplate<Exchange> getCamelTemplate() {
        if (this.camelTemplate == null) {
            CamelContext ctx = this.getCamelContext();
            if (ctx == null) {
                ctx = new DefaultCamelContext();
            }
            this.camelTemplate = ctx.createProducerTemplate();
        }
        return this.camelTemplate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean send(Message<?> message) throws MessageRejectedException, MessageDeliveryException {
        boolean result = false;
        ExchangePattern pattern = this.isExpectReply() ? ExchangePattern.InOut : ExchangePattern.InOnly;
        SpringIntegrationExchange inExchange = new SpringIntegrationExchange(this.getCamelContext(), pattern);
        SpringIntegrationBinding.storeToCamelMessage(message, inExchange.getIn());
        Exchange outExchange = this.getCamelTemplate().send(this.getCamelEndpointUri(), (Exchange)inExchange);
        if (outExchange.getFault() != null) {
            result = true;
        }
        Message response = null;
        if (!this.isExpectReply()) return result;
        response = SpringIntegrationBinding.storeToSpringIntegrationMessage(outExchange.getOut());
        if (this.replyChannel != null) return this.replyChannel.send(response);
        MessageChannel messageReplyChannel = (MessageChannel)message.getHeaders().get((Object)"springintegration_replyChannel");
        if (messageReplyChannel == null) throw new MessageDeliveryException(response, "Can't find reply channel from the CamelTargetAdapter or MessageHeaders");
        return messageReplyChannel.send(response);
    }

    public void handleMessage(Message<?> message) {
        this.send(message);
    }
}

