/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.impl.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlComponent
extends DefaultComponent<Exchange> {
    private DataSource dataSource;

    public SqlComponent() {
    }

    public SqlComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint<Exchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        String dataSourceRef = this.getAndRemoveParameter(parameters, "dataSourceRef", String.class);
        if (dataSourceRef != null) {
            this.dataSource = this.getCamelContext().getRegistry().lookup(dataSourceRef, DataSource.class);
            if (this.dataSource == null) {
                throw new IllegalArgumentException("DataSource " + dataSourceRef + " not found in registry");
            }
        }
        return new SqlEndpoint(uri, remaining.replaceAll("#", "?"), this, this.dataSource, parameters);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

