/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.nio.charset.Charset;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.stream.StreamConsumer;
import org.apache.camel.component.stream.StreamProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamEndpoint
extends DefaultEndpoint<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(StreamEndpoint.class);
    private String uri;
    private String file;
    private String url;
    private long delay;
    private String encoding;

    public StreamEndpoint(String endpointUri, Component component) throws Exception {
        super(endpointUri, component);
        this.uri = endpointUri;
    }

    public StreamEndpoint(String endpointUri) {
        super(endpointUri);
        this.uri = endpointUri;
    }

    @Override
    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        return new StreamConsumer(this, processor, this.uri);
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        return new StreamProducer(this, this.uri);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    Charset getCharset() {
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().name();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No encoding parameter using default charset: " + this.encoding));
            }
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding);
    }
}

