/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.stream.StreamEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamProducer
extends DefaultProducer<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(StreamProducer.class);
    private static final String TYPES = "out,err,file,header,url";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{out,err,file,header,url}'";
    private static final List<String> TYPES_LIST = Arrays.asList("out,err,file,header,url".split(","));
    private OutputStream outputStream = System.out;
    private StreamEndpoint endpoint;
    private String uri;

    public StreamProducer(StreamEndpoint endpoint, String uri) throws Exception {
        super(endpoint);
        this.endpoint = endpoint;
        this.validateUri(uri);
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.delay(this.endpoint.getDelay());
        if ("out".equals(this.uri)) {
            this.outputStream = System.out;
        } else if ("err".equals(this.uri)) {
            this.outputStream = System.err;
        } else if ("file".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromFile();
        } else if ("header".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromHeader(exchange.getIn().getHeader("stream"), exchange);
        } else if ("url".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromUrl();
        }
        this.writeToStream(exchange);
    }

    private OutputStream resolveStreamFromUrl() throws IOException {
        String u = this.endpoint.getUrl();
        URL url = new URL(u);
        URLConnection c = url.openConnection();
        return c.getOutputStream();
    }

    private OutputStream resolveStreamFromFile() throws IOException {
        String fileName = this.endpoint.getFile() != null ? this.endpoint.getFile().trim() : "_file";
        File f = new File(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to write to file: " + f));
        }
        f.createNewFile();
        return new FileOutputStream(f);
    }

    private OutputStream resolveStreamFromHeader(Object o, Exchange exchange) throws CamelExchangeException {
        if (o != null && o instanceof OutputStream) {
            return (OutputStream)o;
        }
        throw new CamelExchangeException("Expected OutputStream in header('stream'), found: " + o, exchange);
    }

    private void delay(long ms) throws InterruptedException {
        if (ms == 0L) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delaying " + ms + " millis"));
        }
        Thread.sleep(ms);
    }

    private void writeToStream(Exchange exchange) throws IOException, CamelExchangeException {
        Object body = exchange.getIn().getBody();
        if (body instanceof String) {
            Charset charset = this.endpoint.getCharset();
            OutputStreamWriter writer = new OutputStreamWriter(this.outputStream, charset);
            BufferedWriter bw = new BufferedWriter(writer);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Writing as text: " + body + " to " + this.outputStream + " using encoding:" + charset));
            }
            bw.write((String)body);
            bw.write("\n");
            bw.flush();
        } else if (body instanceof byte[]) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Writing as text: " + body + " to " + this.outputStream));
            }
            this.outputStream.write((byte[])body);
        } else {
            throw new CamelExchangeException("The body is neither a String or byte array. Can not write body to output stream", exchange);
        }
    }

    private void validateUri(String uri) throws Exception {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (!TYPES_LIST.contains(this.uri)) {
            throw new IllegalArgumentException(INVALID_URI);
        }
    }
}

