/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.BytesSource;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Converter
public class StreamCacheConverter {
    private static final transient Log LOG = LogFactory.getLog(StreamCacheConverter.class);
    private XmlConverter converter = new XmlConverter();

    @Converter
    public StreamCache convertToStreamCache(StreamSource source) throws IOException {
        return new StreamSourceCache(source);
    }

    @Converter
    public StreamCache convertToStreamCache(StringSource source) {
        return null;
    }

    @Converter
    public StreamCache convertToStreamCache(BytesSource source) {
        return null;
    }

    @Converter
    public StreamCache convertToStreamCache(SAXSource source) throws TransformerException {
        return new SourceCache(this.converter.toString(source));
    }

    @Converter
    public StreamCache convertToStreamCache(InputStream stream) throws IOException {
        return new InputStreamCache(IOConverter.toBytes(stream));
    }

    @Converter
    public StreamCache convertToStreamCache(Reader reader) throws IOException {
        return new ReaderCache(IOConverter.toString(reader));
    }

    private class ReaderCache
    extends StringReader
    implements StreamCache {
        public ReaderCache(String s) {
            super(s);
        }

        public void reset() {
            try {
                super.reset();
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception is thrown when resets the ReaderCache", (Throwable)e);
            }
        }

        public void close() {
        }
    }

    private class InputStreamCache
    extends ByteArrayInputStream
    implements StreamCache {
        public InputStreamCache(byte[] data) {
            super(data);
        }
    }

    private class StreamSourceCache
    extends StreamSource
    implements StreamCache {
        InputStreamCache inputStreamCache;
        ReaderCache readCache;

        public StreamSourceCache(StreamSource source) throws IOException {
            if (source.getInputStream() != null) {
                this.inputStreamCache = new InputStreamCache(IOConverter.toBytes(source.getInputStream()));
                this.setInputStream(this.inputStreamCache);
                this.setSystemId(source.getSystemId());
            }
            if (source.getReader() != null) {
                this.readCache = new ReaderCache(IOConverter.toString(source.getReader()));
                this.setReader(this.readCache);
            }
        }

        public void reset() {
            if (this.inputStreamCache != null) {
                this.inputStreamCache.reset();
            }
            if (this.readCache != null) {
                this.readCache.reset();
            }
        }
    }

    private class SourceCache
    extends StringSource
    implements StreamCache {
        private static final long serialVersionUID = 4147248494104812945L;

        public SourceCache() {
        }

        public SourceCache(String text) {
            super(text);
        }

        public void reset() {
        }
    }
}

