/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.hl7;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.hl7.HL7Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;

public class HL7DataFormat
implements DataFormat {
    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        Message message = ExchangeHelper.convertToMandatoryType(exchange, Message.class, body);
        String encoded = HL7Converter.toString(message);
        outputStream.write(encoded.getBytes());
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        String body = ExchangeHelper.convertToMandatoryType(exchange, String.class, inputStream);
        Message message = HL7Converter.toMessage(body);
        Terser terser = new Terser(message);
        exchange.getOut().setHeader("hl7.msh.sendingApplication", terser.get("MSH-3"));
        exchange.getOut().setHeader("hl7.msh.sendingFacility", terser.get("MSH-4"));
        exchange.getOut().setHeader("hl7.msh.receivingApplication", terser.get("MSH-5"));
        exchange.getOut().setHeader("hl7.msh.receivingFacility", terser.get("MSH-6"));
        exchange.getOut().setHeader("hl7.msh.timestamp", terser.get("MSH-7"));
        exchange.getOut().setHeader("hl7.msh.security", terser.get("MSH-8"));
        exchange.getOut().setHeader("hl7.msh.messageType", terser.get("MSH-9-1"));
        exchange.getOut().setHeader("hl7.msh.triggerEvent", terser.get("MSH-9-2"));
        exchange.getOut().setHeader("hl7.msh.messageControl", terser.get("MSH-10"));
        exchange.getOut().setHeader("hl7.msh.processingId", terser.get("MSH-11"));
        exchange.getOut().setHeader("hl7.msh.versionId", terser.get("MSH-12"));
        return message;
    }
}

