/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.ArrayTypeConverter;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.impl.converter.EnumTypeConverter;
import org.apache.camel.impl.converter.PropertyEditorTypeConverter;
import org.apache.camel.impl.converter.ToStringTypeConverter;
import org.apache.camel.impl.converter.TypeConverterLoader;
import org.apache.camel.impl.converter.TypeConverterRegistry;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.util.FactoryFinder;
import org.apache.camel.util.NoFactoryAvailableException;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeConverter
implements TypeConverter,
TypeConverterRegistry {
    private static final transient Log LOG = LogFactory.getLog(DefaultTypeConverter.class);
    private final Map<TypeMapping, TypeConverter> typeMappings = new ConcurrentHashMap<TypeMapping, TypeConverter>();
    private Injector injector;
    private List<TypeConverterLoader> typeConverterLoaders = new ArrayList<TypeConverterLoader>();
    private List<TypeConverter> fallbackConverters = new ArrayList<TypeConverter>();
    private boolean loaded;

    public DefaultTypeConverter(Injector injector) {
        this.typeConverterLoaders.add(new AnnotationTypeConverterLoader());
        this.injector = injector;
        this.addFallbackConverter(new AsyncProcessorTypeConverter());
        this.addFallbackConverter(new PropertyEditorTypeConverter());
        this.addFallbackConverter(new ToStringTypeConverter());
        this.addFallbackConverter(new ArrayTypeConverter());
        this.addFallbackConverter(new EnumTypeConverter());
    }

    public List<TypeConverterLoader> getTypeConverterLoaders() {
        return this.typeConverterLoaders;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        Class primitiveType;
        T rc;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Converting " + (value == null ? "null" : value.getClass().getCanonicalName()) + " -> " + type.getCanonicalName() + " with value: " + value));
        }
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        this.checkLoaded();
        TypeConverter converter = this.getOrFindTypeConverter(type, value);
        if (converter != null && (rc = converter.convertTo(type, exchange, value)) != null) {
            return rc;
        }
        for (TypeConverter fallback : this.fallbackConverters) {
            T rc2 = fallback.convertTo(type, exchange, value);
            if (rc2 == null) continue;
            return rc2;
        }
        if (type.isPrimitive() && (primitiveType = ObjectHelper.convertPrimitiveTypeToWrapperType(type)) != type) {
            return this.convertTo(primitiveType, exchange, value);
        }
        throw new NoTypeConversionAvailableException(value, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTypeConverter(Class toType, Class fromType, TypeConverter typeConverter) {
        TypeMapping key = new TypeMapping(toType, fromType);
        Map<TypeMapping, TypeConverter> map = this.typeMappings;
        synchronized (map) {
            TypeConverter converter = this.typeMappings.get(key);
            if (converter != null) {
                LOG.warn((Object)("Overriding type converter from: " + converter + " to: " + typeConverter));
            }
            this.typeMappings.put(key, typeConverter);
        }
    }

    public void addFallbackConverter(TypeConverter converter) {
        this.fallbackConverters.add(converter);
        if (converter instanceof TypeConverterAware) {
            TypeConverterAware typeConverterAware = (TypeConverterAware)((Object)converter);
            typeConverterAware.setTypeConverter(this);
        }
    }

    public TypeConverter getTypeConverter(Class toType, Class fromType) {
        TypeMapping key = new TypeMapping(toType, fromType);
        return this.typeMappings.get(key);
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> TypeConverter getOrFindTypeConverter(Class toType, Object value) {
        TypeConverter converter;
        Class<?> fromType = null;
        if (value != null) {
            fromType = value.getClass();
        }
        TypeMapping key = new TypeMapping(toType, fromType);
        Map<TypeMapping, TypeConverter> map = this.typeMappings;
        synchronized (map) {
            converter = this.typeMappings.get(key);
            if (converter == null && (converter = this.findTypeConverter(toType, fromType, value)) != null) {
                this.typeMappings.put(key, converter);
            }
        }
        return converter;
    }

    protected TypeConverter findTypeConverter(Class toType, Class fromType, Object value) {
        if (fromType != null) {
            TypeConverter converter;
            Class<Object> fromSuperClass = fromType.getSuperclass();
            if (fromSuperClass != null && !fromSuperClass.equals(Object.class)) {
                converter = this.getTypeConverter(toType, fromSuperClass);
                if (converter == null) {
                    converter = this.findTypeConverter(toType, fromSuperClass, value);
                }
                if (converter != null) {
                    return converter;
                }
            }
            for (Class<?> type : fromType.getInterfaces()) {
                TypeConverter converter2 = this.getTypeConverter(toType, type);
                if (converter2 == null) continue;
                return converter2;
            }
            if (fromType.isArray() && !fromType.getComponentType().isPrimitive() && !fromType.equals(Object[].class)) {
                fromSuperClass = Object[].class;
                converter = this.getTypeConverter(toType, fromSuperClass);
                if (converter == null) {
                    converter = this.findTypeConverter(toType, fromSuperClass, value);
                }
                if (converter != null) {
                    return converter;
                }
            }
            if (!fromType.equals(Object.class) && (converter = this.getTypeConverter(toType, Object.class)) != null) {
                return converter;
            }
        }
        if (fromType != null) {
            Set<Map.Entry<TypeMapping, TypeConverter>> entries = this.typeMappings.entrySet();
            for (Map.Entry<TypeMapping, TypeConverter> entry : entries) {
                TypeMapping key = entry.getKey();
                Class aToType = key.getToType();
                if (!toType.isAssignableFrom(aToType) || !key.getFromType().isAssignableFrom(fromType)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    protected synchronized void checkLoaded() {
        if (!this.loaded) {
            this.loaded = true;
            try {
                for (TypeConverterLoader typeConverterLoader : this.typeConverterLoaders) {
                    typeConverterLoader.load(this);
                }
                try {
                    this.loadFallbackTypeConverters();
                }
                catch (NoFactoryAvailableException e) {}
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    protected void loadFallbackTypeConverters() throws IOException, ClassNotFoundException {
        FactoryFinder finder = new FactoryFinder();
        List<TypeConverter> converters = finder.newInstances("FallbackTypeConverter", this.getInjector(), TypeConverter.class);
        for (TypeConverter converter : converters) {
            this.addFallbackConverter(converter);
        }
    }

    protected static class TypeMapping {
        Class toType;
        Class fromType;

        public TypeMapping(Class toType, Class fromType) {
            this.toType = toType;
            this.fromType = fromType;
        }

        public Class getFromType() {
            return this.fromType;
        }

        public Class getToType() {
            return this.toType;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeMapping) {
                TypeMapping that = (TypeMapping)object;
                return ObjectHelper.equal(this.fromType, that.fromType) && ObjectHelper.equal(this.toType, that.toType);
            }
            return false;
        }

        public int hashCode() {
            int answer = this.toType.hashCode();
            if (this.fromType != null) {
                answer *= 37 + this.fromType.hashCode();
            }
            return answer;
        }

        public String toString() {
            return "[" + this.fromType + "=>" + this.toType + "]";
        }
    }
}

