/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionNode
extends ProcessorType<ProcessorType> {
    @XmlElementRef
    private ExpressionType expression;
    @XmlElementRef
    private List<ProcessorType<?>> outputs = new ArrayList();

    public ExpressionNode() {
    }

    public ExpressionNode(ExpressionType expression) {
        this.expression = expression;
    }

    public ExpressionNode(Expression expression) {
        if (expression != null) {
            this.setExpression(new ExpressionType(expression));
        }
    }

    public ExpressionNode(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(new ExpressionType(predicate));
        }
    }

    @Override
    public String getShortName() {
        return "exp";
    }

    public ExpressionType getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionType expression) {
        this.expression = expression;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.outputs = outputs;
    }

    @Override
    public String getLabel() {
        if (this.getExpression() == null) {
            return "";
        }
        return this.getExpression().getLabel();
    }

    protected FilterProcessor createFilterProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = routeContext.createProcessor(this);
        return new FilterProcessor(this.getExpression().createPredicate(routeContext), childProcessor);
    }

    @Override
    protected void configureChild(ProcessorType output) {
        super.configureChild(output);
        if (this.isInheritErrorHandler()) {
            output.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
        }
    }
}

