/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="interceptor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InterceptorRef
extends InterceptorType {
    @XmlAttribute(required=true)
    private String ref;
    @XmlTransient
    private DelegateProcessor interceptor;

    public InterceptorRef() {
    }

    public InterceptorRef(String ref) {
        this.setRef(ref);
    }

    public InterceptorRef(DelegateProcessor interceptor) {
        this.interceptor = interceptor;
    }

    public String toString() {
        return "Interceptor[" + this.getLabel() + "]";
    }

    public String getShortName() {
        return "interceptor";
    }

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        DelegateProcessor processor = this.createInterceptor(routeContext);
        Processor child = this.createOutputsProcessor(routeContext);
        processor.setProcessor(child);
        return processor;
    }

    public DelegateProcessor createInterceptor(RouteContext routeContext) {
        if (this.interceptor == null) {
            this.interceptor = routeContext.lookup(this.getRef(), DelegateProcessor.class);
        }
        if (this.interceptor == null) {
            throw new IllegalArgumentException("No DelegateProcessor bean available for reference: " + this.getRef());
        }
        return this.interceptor;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getLabel() {
        if (this.ref != null) {
            return "ref:  " + this.ref;
        }
        if (this.interceptor != null) {
            return this.interceptor.toString();
        }
        return "";
    }

    @XmlTransient
    public DelegateProcessor getInterceptor() {
        return this.interceptor;
    }
}

