/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="policy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PolicyRef
extends OutputType<ProcessorType> {
    @XmlAttribute(required=true)
    private String ref;
    @XmlTransient
    private Policy policy;

    public PolicyRef() {
    }

    public PolicyRef(Policy policy) {
        this.policy = policy;
    }

    public String toString() {
        return "Policy[" + this.description() + "]";
    }

    @Override
    public String getShortName() {
        return "policy";
    }

    @Override
    public String getLabel() {
        if (this.ref != null) {
            return "ref:  " + this.ref;
        }
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createOutputsProcessor(routeContext);
        Policy policy = this.resolvePolicy(routeContext);
        if (policy == null) {
            throw new IllegalArgumentException("No policy configured: " + this);
        }
        return policy.wrap(childProcessor);
    }

    protected Policy resolvePolicy(RouteContext routeContext) {
        if (this.policy == null) {
            this.policy = routeContext.lookup(this.getRef(), Policy.class);
        }
        return this.policy;
    }

    protected String description() {
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "ref: " + this.ref;
    }
}

