/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.model.loadbalancer.LoadBalancerType;
import org.apache.camel.processor.loadbalancer.LoadBalancer;

@XmlRootElement(name="sticky")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StickyLoadBalanceStrategy
extends LoadBalancerType {
    @XmlElement(required=true, name="expression", type=ExpressionType.class)
    private ExpressionType expressionType;
    @XmlElement(required=false, name="loadBalancer", type=LoadBalancerType.class)
    private LoadBalancerType loadBalancerType;

    public StickyLoadBalanceStrategy() {
        super("org.apache.camel.processor.loadbalancer.StickyLoadBalancer");
    }

    public StickyLoadBalanceStrategy(ExpressionType expressionType) {
        this();
        this.expressionType = expressionType;
    }

    public StickyLoadBalanceStrategy(ExpressionType expressionType, LoadBalancerType loadBalancerType) {
        this();
        this.expressionType = expressionType;
        this.loadBalancerType = loadBalancerType;
    }

    public void setExpressionType(ExpressionType expressionType) {
        this.expressionType = expressionType;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public void setLoadBalancerType(LoadBalancerType loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
    }

    public LoadBalancerType getLoadBalancerType() {
        return this.loadBalancerType;
    }

    protected void configureLoadBalancer(LoadBalancer loadBalancer) {
        LoadBalancerType type;
        ExpressionType expression = this.getExpressionType();
        if (expression != null) {
            this.setProperty(loadBalancer, "correlationExpression", expression);
        }
        if ((type = this.getLoadBalancerType()) != null) {
            this.setProperty(loadBalancer, "loadBalancer", type);
        }
    }

    public String toString() {
        return "StickyLoadBalanceStrategy[" + this.expressionType + ", " + this.loadBalancerType + "]";
    }
}

