/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProcessor
extends ServiceSupport
implements Processor {
    public static final long DEFAULT_BATCH_TIMEOUT = 1000L;
    public static final int DEFAULT_BATCH_SIZE = 100;
    private long batchTimeout = 1000L;
    private int batchSize = 100;
    private int outBatchSize;
    private Processor processor;
    private Collection<Exchange> collection;
    private ExceptionHandler exceptionHandler;
    private BatchSender sender;

    public BatchProcessor(Processor processor, Collection<Exchange> collection) {
        this.processor = processor;
        this.collection = collection;
        this.sender = new BatchSender();
    }

    public String toString() {
        return "BatchProcessor[to: " + this.processor + "]";
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getOutBatchSize() {
        return this.outBatchSize;
    }

    public void setOutBatchSize(int outBatchSize) {
        this.outBatchSize = outBatchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    protected boolean isInBatchCompleted(int num) {
        return num >= this.batchSize;
    }

    protected boolean isOutBatchCompleted() {
        if (this.outBatchSize == 0) {
            return true;
        }
        return this.collection.size() > 0 && this.collection.size() >= this.outBatchSize;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
        this.sender.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.sender.cancel();
        ServiceHelper.stopServices(this.processor);
        this.collection.clear();
    }

    protected Collection<Exchange> getCollection() {
        return this.collection;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.sender.enqueueExchange(exchange);
    }

    private class BatchSender
    extends Thread {
        private volatile boolean cancelRequested;
        private LinkedBlockingQueue<Exchange> queue;

        public BatchSender() {
            super("Batch Sender");
            this.queue = new LinkedBlockingQueue();
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(BatchProcessor.this.batchTimeout);
                    this.queue.drainTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize);
                }
                catch (InterruptedException e) {
                    if (this.cancelRequested) {
                        return;
                    }
                    while (BatchProcessor.this.isInBatchCompleted(this.queue.size())) {
                        this.queue.drainTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize);
                    }
                    if (!BatchProcessor.this.isOutBatchCompleted()) continue;
                }
                try {
                    this.sendExchanges();
                    continue;
                }
                catch (Exception e) {
                    BatchProcessor.this.getExceptionHandler().handleException(e);
                    continue;
                }
                break;
            }
        }

        public void cancel() {
            this.cancelRequested = true;
            this.interrupt();
        }

        public void enqueueExchange(Exchange exchange) {
            this.queue.add(exchange);
            this.interrupt();
        }

        private void sendExchanges() throws Exception {
            Iterator iter = BatchProcessor.this.collection.iterator();
            while (iter.hasNext()) {
                Exchange exchange = (Exchange)iter.next();
                iter.remove();
                BatchProcessor.this.processExchange(exchange);
            }
        }
    }
}

