/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.ReflectionUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

@XmlRootElement(name="beanPostProcessor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelBeanPostProcessor.class);
    @XmlTransient
    private SpringCamelContext camelContext;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private CamelPostProcessorHelper postProcessor;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.injectFields(bean);
        this.injectMethods(bean);
        if (bean instanceof CamelContextAware) {
            CamelContextAware contextAware = (CamelContextAware)bean;
            if (this.camelContext == null) {
                LOG.warn((Object)("No CamelContext defined yet so cannot inject into: " + bean));
            } else {
                contextAware.setCamelContext(this.camelContext);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DefaultEndpoint) {
            DefaultEndpoint defaultEndpoint = (DefaultEndpoint)bean;
            defaultEndpoint.setEndpointUriIfNotSpecified(beanName);
        }
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public SpringCamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(SpringCamelContext camelContext) {
        this.camelContext = camelContext;
        this.postProcessor = new CamelPostProcessorHelper(camelContext){

            @Override
            protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
                return new BeanInstantiationException(type, "Could not instantiate proxy of type " + type.getName() + " on endpoint " + endpoint, (Throwable)e);
            }
        };
    }

    protected void injectFields(final Object bean) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Produce produce;
                EndpointInject annotation = field.getAnnotation(EndpointInject.class);
                if (annotation != null) {
                    CamelBeanPostProcessor.this.injectField(field, annotation.uri(), annotation.name(), bean);
                }
                if ((produce = field.getAnnotation(Produce.class)) != null) {
                    CamelBeanPostProcessor.this.injectField(field, produce.uri(), produce.ref(), bean);
                }
            }
        });
    }

    protected void injectField(Field field, String endpointUri, String endpointRef, Object bean) {
        ReflectionUtils.setField(field, bean, this.getPostProcessor().getInjectionValue(field.getType(), endpointUri, endpointRef, field.getName()));
    }

    protected void injectMethods(final Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                CamelBeanPostProcessor.this.setterInjection(method, bean);
                CamelBeanPostProcessor.this.getPostProcessor().consumerInjection(method, bean);
            }
        });
    }

    protected void setterInjection(Method method, Object bean) {
        Produce produce;
        EndpointInject annoation = method.getAnnotation(EndpointInject.class);
        if (annoation != null) {
            this.setterInjection(method, bean, annoation.uri(), annoation.name());
        }
        if ((produce = method.getAnnotation(Produce.class)) != null) {
            this.setterInjection(method, bean, produce.uri(), produce.ref());
        }
    }

    protected void setterInjection(Method method, Object bean, String endpointUri, String endpointRef) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null) {
            if (parameterTypes.length != 1) {
                LOG.warn((Object)("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method));
            } else {
                String propertyName = ObjectHelper.getPropertyName(method);
                Object value = this.getPostProcessor().getInjectionValue(parameterTypes[0], endpointUri, endpointRef, propertyName);
                ObjectHelper.invokeMethod(method, bean, value);
            }
        }
    }

    protected void consumerInjection(Object bean) {
        org.springframework.util.ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            }
        });
    }

    public CamelPostProcessorHelper getPostProcessor() {
        ObjectHelper.notNull(this.postProcessor, "postProcessor");
        return this.postProcessor;
    }
}

