/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Processor;
import org.apache.camel.spi.Policy;
import org.apache.camel.spring.spi.TransactionInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTransactionPolicy<E>
implements Policy<E> {
    private static final transient Log LOG = LogFactory.getLog(SpringTransactionPolicy.class);
    private TransactionTemplate template;
    private String propagationBehaviorName;
    private PlatformTransactionManager transactionManager;

    public SpringTransactionPolicy() {
    }

    public SpringTransactionPolicy(TransactionTemplate template) {
        this.template = template;
    }

    @Override
    public Processor wrap(Processor processor) {
        TransactionTemplate transactionTemplate = this.getTemplate();
        if (transactionTemplate == null) {
            LOG.warn((Object)"No TransactionTemplate available so transactions will not be enabled!");
            return processor;
        }
        TransactionInterceptor answer = new TransactionInterceptor(transactionTemplate);
        answer.setProcessor(processor);
        return answer;
    }

    public TransactionTemplate getTemplate() {
        if (this.template == null) {
            this.template = new TransactionTemplate(this.transactionManager);
            if (this.propagationBehaviorName != null) {
                this.template.setPropagationBehaviorName(this.propagationBehaviorName);
            }
        }
        return this.template;
    }

    public void setTemplate(TransactionTemplate template) {
        this.template = template;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setPropagationBehaviorName(String propagationBehaviorName) {
        this.propagationBehaviorName = propagationBehaviorName;
    }

    public String getPropagationBehaviorName() {
        return this.propagationBehaviorName;
    }
}

