/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.camel.util.ResolverUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSphereResolverUtil
extends ResolverUtil {
    private String resourcePath;

    public WebSphereResolverUtil(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public static boolean isWebSphereClassLoader(ClassLoader loader) {
        return loader.getClass().getName().startsWith("com.ibm");
    }

    @Override
    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        Enumeration<URL> enumeration = super.getResources(loader, packageName);
        if (!enumeration.hasMoreElements()) {
            LOG.trace((Object)"Using WebSphere workaround to load the camel jars with the annotated converters.");
            enumeration = loader.getResources(this.resourcePath);
        }
        return enumeration;
    }
}

