/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.rules;

import java.util.ArrayList;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.bam.TimeExpression;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.RouteType;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.Time;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemporalRule
extends ServiceSupport {
    private static final transient Log LOG = LogFactory.getLog(TemporalRule.class);
    private TimeExpression first;
    private TimeExpression second;
    private long expectedMillis;
    private long overdueMillis;
    private Processor overdueAction;
    private OutputType overdueProcessors = new OutputType();

    public TemporalRule(TimeExpression first, TimeExpression second) {
        this.first = first;
        this.second = second;
    }

    public TemporalRule expectWithin(Time builder) {
        return this.expectWithin(builder.toMillis());
    }

    public TemporalRule expectWithin(long millis) {
        this.expectedMillis = millis;
        return this;
    }

    public OutputType errorIfOver(Time builder) {
        return this.errorIfOver(builder.toMillis());
    }

    public OutputType errorIfOver(long millis) {
        this.overdueMillis = millis;
        if (this.overdueProcessors == null) {
            this.overdueProcessors = new OutputType();
        }
        return this.overdueProcessors;
    }

    public TimeExpression getFirst() {
        return this.first;
    }

    public TimeExpression getSecond() {
        return this.second;
    }

    public Processor getOverdueAction() throws Exception {
        if (this.overdueAction == null && this.overdueProcessors != null) {
            ArrayList<Route> list = new ArrayList<Route>();
            RouteType route = new RouteType();
            route.setCamelContext(this.first.getBuilder().getProcessBuilder().getContext());
            DefaultRouteContext routeContext = new DefaultRouteContext(route, null, list);
            this.overdueAction = this.overdueProcessors.createOutputsProcessor(routeContext);
        }
        return this.overdueAction;
    }

    public void processExchange(Exchange exchange, ProcessInstance instance) {
        Date overdue;
        Date expected;
        Date firstTime = this.first.evaluate(instance);
        if (firstTime == null) {
            return;
        }
        ActivityState secondState = this.second.getOrCreateActivityState(instance);
        if (this.expectedMillis > 0L && (expected = secondState.getTimeExpected()) == null) {
            expected = this.add(firstTime, this.expectedMillis);
            secondState.setTimeExpected(expected);
        }
        if (this.overdueMillis > 0L && (overdue = secondState.getTimeOverdue()) == null) {
            overdue = this.add(firstTime, this.overdueMillis);
            secondState.setTimeOverdue(overdue);
        }
    }

    public void processExpired(ActivityState activityState) throws Exception {
        Processor processor = this.getOverdueAction();
        if (processor != null) {
            Date now = new Date();
            ActivityState secondState = activityState;
            Date overdue = secondState.getTimeOverdue();
            if (now.compareTo(overdue) >= 0) {
                Exchange exchange = this.createExchange();
                exchange.getIn().setBody(activityState);
                processor.process(exchange);
            } else {
                LOG.warn((Object)("Process has not actually expired; the time is: " + now + " but the overdue time is: " + overdue));
            }
        }
    }

    protected Exchange createExchange() {
        return new DefaultExchange(this.second.getBuilder().getProcessBuilder().getContext());
    }

    protected Date add(Date date, long millis) {
        return new Date(date.getTime() + millis);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.getOverdueAction());
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.getOverdueAction());
    }
}

