/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.script;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.script.ScriptEvaluationException;
import org.apache.camel.converter.ObjectConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBuilder<E extends Exchange>
implements Expression<E>,
Predicate<E>,
Processor {
    private static final transient Log LOG = LogFactory.getLog(ScriptBuilder.class);
    private String scriptEngineName;
    private Resource scriptResource;
    private String scriptText;
    private ScriptEngine engine;
    private CompiledScript compiledScript;

    public ScriptBuilder(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public ScriptBuilder(String scriptEngineName, String scriptText) {
        this(scriptEngineName);
        this.scriptText = scriptText;
    }

    public ScriptBuilder(String scriptEngineName, Resource scriptResource) {
        this(scriptEngineName);
        this.scriptResource = scriptResource;
    }

    public String toString() {
        return this.getScriptDescription();
    }

    @Override
    public Object evaluate(E exchange) {
        return this.evaluateScript((Exchange)exchange);
    }

    @Override
    public boolean matches(E exchange) {
        Object scriptValue = this.evaluateScript((Exchange)exchange);
        return this.matches(exchange, scriptValue);
    }

    @Override
    public void assertMatches(String text, E exchange) throws AssertionError {
        Object scriptValue = this.evaluateScript((Exchange)exchange);
        if (!this.matches(exchange, scriptValue)) {
            throw new AssertionError((Object)(this + " failed on " + exchange + " as script returned <" + scriptValue + ">"));
        }
    }

    @Override
    public void process(Exchange exchange) {
        this.evaluateScript(exchange);
    }

    public ScriptBuilder attribute(String name, Object value) {
        this.getScriptContext().setAttribute(name, value, 100);
        return this;
    }

    public static ScriptBuilder script(String language, String scriptText) {
        return new ScriptBuilder(language, scriptText);
    }

    public static ScriptBuilder script(String language, Resource scriptResource) {
        return new ScriptBuilder(language, scriptResource);
    }

    public static ScriptBuilder script(String language, File scriptFile) {
        return new ScriptBuilder(language, (Resource)new FileSystemResource(scriptFile));
    }

    public static ScriptBuilder script(String language, URL scriptURL) {
        return new ScriptBuilder(language, (Resource)new UrlResource(scriptURL));
    }

    public static ScriptBuilder beanShell(String scriptText) {
        return new ScriptBuilder("beanshell", scriptText);
    }

    public static ScriptBuilder beanShell(Resource scriptResource) {
        return new ScriptBuilder("beanshell", scriptResource);
    }

    public static ScriptBuilder beanShell(File scriptFile) {
        return new ScriptBuilder("beanshell", (Resource)new FileSystemResource(scriptFile));
    }

    public static ScriptBuilder beanShell(URL scriptURL) {
        return new ScriptBuilder("beanshell", (Resource)new UrlResource(scriptURL));
    }

    public static ScriptBuilder groovy(String scriptText) {
        return new ScriptBuilder("groovy", scriptText);
    }

    public static ScriptBuilder groovy(Resource scriptResource) {
        return new ScriptBuilder("groovy", scriptResource);
    }

    public static ScriptBuilder groovy(File scriptFile) {
        return new ScriptBuilder("groovy", (Resource)new FileSystemResource(scriptFile));
    }

    public static ScriptBuilder groovy(URL scriptURL) {
        return new ScriptBuilder("groovy", (Resource)new UrlResource(scriptURL));
    }

    public static ScriptBuilder javaScript(String scriptText) {
        return new ScriptBuilder("js", scriptText);
    }

    public static ScriptBuilder javaScript(Resource scriptResource) {
        return new ScriptBuilder("js", scriptResource);
    }

    public static ScriptBuilder javaScript(File scriptFile) {
        return new ScriptBuilder("js", (Resource)new FileSystemResource(scriptFile));
    }

    public static ScriptBuilder javaScript(URL scriptURL) {
        return new ScriptBuilder("js", (Resource)new UrlResource(scriptURL));
    }

    public static ScriptBuilder php(String scriptText) {
        return new ScriptBuilder("php", scriptText);
    }

    public static ScriptBuilder php(Resource scriptResource) {
        return new ScriptBuilder("php", scriptResource);
    }

    public static ScriptBuilder php(File scriptFile) {
        return new ScriptBuilder("php", (Resource)new FileSystemResource(scriptFile));
    }

    public static ScriptBuilder php(URL scriptURL) {
        return new ScriptBuilder("php", (Resource)new UrlResource(scriptURL));
    }

    public static ScriptBuilder python(String scriptText) {
        return new ScriptBuilder("python", scriptText);
    }

    public static ScriptBuilder python(Resource scriptResource) {
        return new ScriptBuilder("python", scriptResource);
    }

    public static ScriptBuilder python(File scriptFile) {
        return new ScriptBuilder("python", (Resource)new FileSystemResource(scriptFile));
    }

    public static ScriptBuilder python(URL scriptURL) {
        return new ScriptBuilder("python", (Resource)new UrlResource(scriptURL));
    }

    public static ScriptBuilder ruby(String scriptText) {
        return new ScriptBuilder("jruby", scriptText);
    }

    public static ScriptBuilder ruby(Resource scriptResource) {
        return new ScriptBuilder("jruby", scriptResource);
    }

    public static ScriptBuilder ruby(File scriptFile) {
        return new ScriptBuilder("jruby", (Resource)new FileSystemResource(scriptFile));
    }

    public static ScriptBuilder ruby(URL scriptURL) {
        return new ScriptBuilder("jruby", (Resource)new UrlResource(scriptURL));
    }

    public ScriptEngine getEngine() {
        this.checkInitialised();
        if (this.engine == null) {
            throw new IllegalArgumentException("No script engine could be created for: " + this.getScriptEngineName());
        }
        return this.engine;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public String getScriptDescription() {
        if (this.scriptText != null) {
            return this.scriptEngineName + ": " + this.scriptText;
        }
        if (this.scriptResource != null) {
            return this.scriptEngineName + ": " + this.scriptResource.getDescription();
        }
        return this.scriptEngineName + ": null script";
    }

    public ScriptContext getScriptContext() {
        return this.getEngine().getContext();
    }

    public void setScriptContext(ScriptContext scriptContext) {
        this.getEngine().setContext(scriptContext);
    }

    public Resource getScriptResource() {
        return this.scriptResource;
    }

    public void setScriptResource(Resource scriptResource) {
        this.scriptResource = scriptResource;
    }

    protected void checkInitialised() {
        if (this.scriptText == null && this.scriptResource == null) {
            throw new IllegalArgumentException("Neither scriptText or scriptResource are specified");
        }
        if (this.engine == null) {
            this.engine = this.createScriptEngine();
        }
        if (this.compiledScript == null && this.engine instanceof Compilable) {
            this.compileScript((Compilable)((Object)this.engine));
        }
    }

    protected boolean matches(E exchange, Object scriptValue) {
        return ObjectConverter.toBool(scriptValue);
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        try {
            this.engine = manager.getEngineByName(this.scriptEngineName);
        }
        catch (NoClassDefFoundError ex) {
            LOG.error((Object)("Can't load the scriptEngine for " + this.scriptEngineName + ", the exception is " + ex + ", please check the scriptEngine needs jars."));
        }
        if (this.engine == null) {
            throw new IllegalArgumentException("No script engine could be created for: " + this.getScriptEngineName());
        }
        if (this.isPython()) {
            ScriptContext context = this.engine.getContext();
            context.setAttribute("com.sun.script.jython.comp.mode", "eval", 100);
        }
        return this.engine;
    }

    protected void compileScript(Compilable compilable) {
        try {
            if (this.scriptText != null) {
                this.compiledScript = compilable.compile(this.scriptText);
            } else if (this.scriptResource != null) {
                this.compiledScript = compilable.compile(this.createScriptReader());
            }
        }
        catch (ScriptException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Script compile failed: " + e), (Throwable)e);
            }
            throw this.createScriptCompileException(e);
        }
        catch (IOException e) {
            throw this.createScriptCompileException(e);
        }
    }

    protected synchronized Object evaluateScript(Exchange exchange) {
        try {
            this.getScriptContext();
            this.populateBindings(this.getEngine(), exchange);
            Object result = this.runScript();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The script evaluation result is: " + result));
            }
            return result;
        }
        catch (ScriptException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Script evaluation failed: " + e), (Throwable)e);
            }
            throw this.createScriptEvaluationException(e.getCause());
        }
        catch (IOException e) {
            throw this.createScriptEvaluationException(e);
        }
    }

    protected Object runScript() throws ScriptException, IOException {
        this.checkInitialised();
        Object result = null;
        result = this.compiledScript != null ? this.compiledScript.eval() : (this.scriptText != null ? this.getEngine().eval(this.scriptText) : this.getEngine().eval(this.createScriptReader()));
        return result;
    }

    protected void populateBindings(ScriptEngine engine, Exchange exchange) {
        ScriptContext context = engine.getContext();
        int scope = 100;
        context.setAttribute("context", exchange.getContext(), scope);
        context.setAttribute("exchange", exchange, scope);
        context.setAttribute("request", exchange.getIn(), scope);
        context.setAttribute("response", exchange.getOut(false), scope);
    }

    protected InputStreamReader createScriptReader() throws IOException {
        return new InputStreamReader(this.scriptResource.getInputStream());
    }

    protected ScriptEvaluationException createScriptCompileException(Exception e) {
        return new ScriptEvaluationException("Failed to compile: " + this.getScriptDescription() + ". Cause: " + e, e);
    }

    protected ScriptEvaluationException createScriptEvaluationException(Throwable e) {
        if (e.getClass().getName().equals("org.jruby.exceptions.RaiseException")) {
            try {
                Object ex = e.getClass().getMethod("getException", new Class[0]).invoke((Object)e, new Object[0]);
                return new ScriptEvaluationException("Failed to evaluate: " + this.getScriptDescription() + ".  Error: " + ex + ". Cause: " + e, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ScriptEvaluationException("Failed to evaluate: " + this.getScriptDescription() + ". Cause: " + e, e);
    }

    protected boolean isPython() {
        return "python".equals(this.scriptEngineName) || "jython".equals(this.scriptEngineName);
    }
}

