/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.invoker.CxfClient;
import org.apache.camel.component.cxf.invoker.CxfClientFactoryBean;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.camel.component.cxf.invoker.InvokingContextFactory;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfProducer
extends DefaultProducer<CxfExchange> {
    private static final Logger LOG = LogUtils.getL7dLogger(CxfProducer.class);
    private CxfEndpoint endpoint;
    private Client client;
    private DataFormat dataFormat;

    public CxfProducer(CxfEndpoint endpoint) throws Exception {
        super(endpoint);
        this.endpoint = endpoint;
        this.dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        this.client = this.dataFormat.equals((Object)DataFormat.POJO) ? this.createClientFromClientFactoryBean(null) : this.createClientForStreamMessage();
    }

    private Client createClientForStreamMessage() throws Exception {
        CxfClientFactoryBean cfb = new CxfClientFactoryBean();
        Class serviceClass = null;
        try {
            serviceClass = CxfEndpointUtils.getServiceClass(this.endpoint);
        }
        catch (ClassNotFoundException e) {
            throw new CamelException(e);
        }
        boolean jsr181Enabled = CxfEndpointUtils.hasWebServiceAnnotation(serviceClass);
        cfb.setJSR181Enabled(jsr181Enabled);
        return this.createClientFromClientFactoryBean((ClientProxyFactoryBean)(jsr181Enabled ? new JaxWsProxyFactoryBean((ClientFactoryBean)cfb) : new ClientProxyFactoryBean((ClientFactoryBean)cfb)));
    }

    private Client createClientFromClientFactoryBean(ClientProxyFactoryBean cfb) throws Exception {
        Bus bus = null;
        if (this.endpoint.getApplicationContext() != null) {
            if (this.endpoint.getCxfEndpointBean() != null) {
                bus = this.endpoint.getCxfEndpointBean().getBus();
            } else {
                SpringBusFactory busFactory = new SpringBusFactory(this.endpoint.getApplicationContext());
                bus = busFactory.createBus();
            }
            if (CxfEndpointUtils.getSetDefaultBus(this.endpoint)) {
                BusFactory.setDefaultBus((Bus)bus);
            }
        } else {
            bus = BusFactory.getDefaultBus();
        }
        Class serviceClass = CxfEndpointUtils.getServiceClass(this.endpoint);
        if (cfb == null) {
            cfb = CxfEndpointUtils.getClientFactoryBean(serviceClass);
        }
        if (this.endpoint.isSpringContextEndpoint()) {
            this.endpoint.configure(cfb);
        } else {
            cfb.setAddress(this.endpoint.getAddress());
            if (null != this.endpoint.getServiceClass()) {
                cfb.setServiceClass(ObjectHelper.loadClass(this.endpoint.getServiceClass()));
            }
            if (null != this.endpoint.getWsdlURL()) {
                cfb.setWsdlURL(this.endpoint.getWsdlURL());
            }
            if (this.endpoint.getWsdlURL() != null) {
                cfb.setWsdlURL(this.endpoint.getWsdlURL());
            }
        }
        cfb.setServiceClass(serviceClass);
        if (CxfEndpointUtils.getServiceName(this.endpoint) != null) {
            cfb.setServiceName(CxfEndpointUtils.getServiceName(this.endpoint));
        }
        if (CxfEndpointUtils.getPortName(this.endpoint) != null) {
            cfb.setEndpointName(CxfEndpointUtils.getPortName(this.endpoint));
        }
        if (this.dataFormat.equals((Object)DataFormat.MESSAGE)) {
            cfb.getFeatures().add(new MessageDataFormatFeature());
        } else if (this.dataFormat.equals((Object)DataFormat.PAYLOAD)) {
            cfb.getFeatures().add(new PayLoadDataFormatFeature());
        }
        cfb.setBus(bus);
        return ((ClientProxy)Proxy.getInvocationHandler(cfb.create())).getClient();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        CxfExchange cxfExchange = (CxfExchange)this.endpoint.createExchange(exchange);
        this.process(cxfExchange);
        exchange.copyFrom(cxfExchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(CxfExchange exchange) throws Exception {
        Message inMessage = CxfBinding.createCxfMessage(this.endpoint.getHeaderFilterStrategy(), exchange);
        exchange.setProperty("CamelCXFDataFormat", (Object)this.dataFormat);
        if (this.dataFormat.equals((Object)DataFormat.POJO)) {
            ArrayList parameters = (ArrayList)inMessage.getContent(List.class);
            if (parameters == null) {
                parameters = new ArrayList();
            }
            String operationName = exchange.getIn().getHeader("operationName", String.class);
            String operationNameSpace = exchange.getIn().getHeader("operationNameSpace", String.class);
            HashMap<String, Object> context = new HashMap<String, Object>();
            Map<String, Object> responseContext = CxfBinding.propogateContext(exchange, context);
            CxfBinding.relayRequestHeaders(this.endpoint, exchange, context);
            MessageImpl response = new MessageImpl();
            if (operationName == null) throw new RuntimeCamelException("Can't find the operation name in the message!");
            Object[] result = null;
            result = this.invokeClient(operationNameSpace, operationName, parameters, context);
            if (result != null) {
                response.setContent(List.class, (Object)new MessageContentsList(result));
            } else {
                response.setContent(List.class, (Object)new MessageContentsList());
            }
            CxfBinding.storeCXfResponseContext((Message)response, responseContext);
            CxfBinding.storeCxfResponse(this.endpoint.getHeaderFilterStrategy(), exchange, (Message)response);
            CxfBinding.relayResponseHeaders(this.endpoint, exchange, context);
            return;
        }
        org.apache.cxf.message.Exchange ex = exchange.getExchange();
        if (ex == null) {
            ex = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange");
            exchange.setExchange(ex);
        }
        if (ex == null) {
            ex = new ExchangeImpl();
            exchange.setExchange(ex);
        }
        ObjectHelper.notNull(ex, "exchange");
        InvokingContext invokingContext = (InvokingContext)ex.get(InvokingContext.class);
        if (invokingContext == null) {
            invokingContext = InvokingContextFactory.createContext(this.dataFormat);
            ex.put(InvokingContext.class, (Object)invokingContext);
        }
        Map<Class, Object> params = invokingContext.getRequestContent(inMessage);
        CxfClient cxfClient = (CxfClient)this.client;
        BindingOperationInfo orig = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        BindingOperationInfo boi = this.getBindingOperationInfo(exchange);
        ex.put(BindingOperationInfo.class, (Object)boi);
        MessageImpl response = null;
        if (boi == null) {
            response = new MessageImpl();
        } else {
            Endpoint ep = (Endpoint)ex.get(Endpoint.class);
            response = ep.getBinding().createMessage();
        }
        response.setExchange(ex);
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, Object> responseContext = CxfBinding.propogateContext(exchange, context);
        Object result = null;
        try {
            result = cxfClient.dispatch(params, context, ex);
        }
        finally {
            ex.put(BindingOperationInfo.class, (Object)orig);
        }
        ex.setOutMessage((Message)response);
        invokingContext.setResponseContent((Message)response, result);
        CxfBinding.storeCXfResponseContext((Message)response, responseContext);
        CxfBinding.storeCxfResponse(this.endpoint.getHeaderFilterStrategy(), exchange, (Message)response);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    private Object[] invokeClient(String operationNameSpace, String operationName, List parameters, Map<String, Object> context) throws Exception {
        QName operationQName = null;
        operationQName = operationNameSpace == null ? new QName(this.client.getEndpoint().getService().getName().getNamespaceURI(), operationName) : new QName(operationNameSpace, operationName);
        BindingOperationInfo op = this.client.getEndpoint().getEndpointInfo().getBinding().getOperation(operationQName);
        if (op == null) {
            throw new RuntimeCamelException("No operation found in the CXF client, the operation is " + operationQName);
        }
        if (!this.endpoint.isWrapped() && op.isUnwrappedCapable()) {
            op = op.getUnwrappedOperation();
        }
        Object[] result = this.client.invoke(op, parameters.toArray(), context);
        return result;
    }

    public Client getClient() {
        return this.client;
    }

    private BindingOperationInfo getBindingOperationInfo(CxfExchange ex) {
        BindingOperationInfo answer = null;
        String lp = ex.getIn().getHeader("operationName", String.class);
        if (lp == null) {
            LOG.fine("Try get the BindingOperationInfo from cxfExchange.");
            org.apache.cxf.message.Exchange cxfExchange = ex.getExchange();
            answer = (BindingOperationInfo)cxfExchange.get(BindingOperationInfo.class);
        } else {
            String ns = ex.getIn().getHeader("operationNameSpace", String.class);
            if (ns == null) {
                ns = this.client.getEndpoint().getService().getName().getNamespaceURI();
                LOG.finer("Operation namespace not in header.  Set it to: " + ns);
            }
            QName qname = new QName(ns, lp);
            LOG.finer("Operation qname = " + qname.toString());
            answer = this.client.getEndpoint().getEndpointInfo().getBinding().getOperation(qname);
        }
        return answer;
    }
}

