/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.interceptors.FakeBindingOperationInfo;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.xml.XMLFault;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(FaultOutInterceptor.class);

    public FaultOutInterceptor() {
        super("prepare-send");
    }

    public void handleMessage(Message message) throws Fault {
        this.checkBindingOperationInfor(message);
        Throwable ex = (Throwable)message.getContent(Throwable.class);
        if (ex != null) {
            if (!(ex instanceof Fault)) {
                ex = new Fault(ex);
            }
            if (message instanceof XMLMessage) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("FaultOutInterceptor Creating XMLFault");
                }
                ex = XMLFault.createFault((Fault)((Fault)ex));
            } else if (message instanceof SoapMessage) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("FaultOutInterceptor Creating SoapFault");
                }
                SoapMessage sm = (SoapMessage)message;
                ex = SoapFault.createFault((Fault)((Fault)ex), (SoapVersion)sm.getVersion());
            }
            message.setContent(Throwable.class, (Object)ex);
        }
    }

    private void checkBindingOperationInfor(Message message) {
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (bop == null) {
            bop = new FakeBindingOperationInfo();
            message.getExchange().put(BindingOperationInfo.class, (Object)bop);
        }
    }
}

