/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.DirectProducer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectEndpoint<E extends Exchange>
extends DefaultEndpoint<E> {
    private static final transient Log LOG = LogFactory.getLog(DirectEndpoint.class);
    private boolean allowMultipleConsumers = true;
    private final CopyOnWriteArrayList<DefaultConsumer<E>> consumers = new CopyOnWriteArrayList();

    public DirectEndpoint(String uri, DirectComponent<E> component) {
        super(uri, component);
    }

    public DirectEndpoint(String endpointUri) {
        super(endpointUri);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DirectProducer(this);
    }

    @Override
    public Consumer<E> createConsumer(Processor processor) throws Exception {
        return new DefaultConsumer<E>(this, processor){

            @Override
            public void start() throws Exception {
                if (!DirectEndpoint.this.allowMultipleConsumers && !DirectEndpoint.this.consumers.isEmpty()) {
                    throw new IllegalStateException("Endpoint " + DirectEndpoint.this.getEndpointUri() + " only allows 1 active consumer but you attempted to start a 2nd consumer.");
                }
                DirectEndpoint.this.consumers.add(this);
                super.start();
            }

            @Override
            public void stop() throws Exception {
                super.stop();
                DirectEndpoint.this.consumers.remove(this);
            }
        };
    }

    public boolean isAllowMultipleConsumers() {
        return this.allowMultipleConsumers;
    }

    public void setAllowMultipleConsumers(boolean allowMutlipleConsumers) {
        this.allowMultipleConsumers = allowMutlipleConsumers;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public List<DefaultConsumer<E>> getConsumers() {
        return this.consumers;
    }
}

