/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.event;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.event.CamelEvent;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventEndpoint
extends DefaultEndpoint<Exchange>
implements ApplicationContextAware {
    private LoadBalancer loadBalancer;
    private ApplicationContext applicationContext;

    public EventEndpoint(String endpointUri, EventComponent component) {
        super(endpointUri, component);
        this.applicationContext = component.getApplicationContext();
    }

    public EventEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        ObjectHelper.notNull(this.getApplicationContext(), "applicationContext");
        return new DefaultProducer<Exchange>((Endpoint)this){

            @Override
            public void process(Exchange exchange) throws Exception {
                ApplicationEvent event = EventEndpoint.this.toApplicationEvent(exchange);
                EventEndpoint.this.getApplicationContext().publishEvent(event);
            }
        };
    }

    public EventConsumer createConsumer(Processor processor) throws Exception {
        return new EventConsumer(this, processor);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Object exchange = this.createExchange();
        exchange.getIn().setBody(event);
        try {
            this.getLoadBalancer().process((Exchange)exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public synchronized void consumerStarted(EventConsumer consumer) {
        this.getLoadBalancer().addProcessor(consumer.getProcessor());
    }

    public synchronized void consumerStopped(EventConsumer consumer) {
        this.getLoadBalancer().removeProcessor(consumer.getProcessor());
    }

    protected LoadBalancer createLoadBalancer() {
        return new TopicLoadBalancer();
    }

    protected ApplicationEvent toApplicationEvent(Exchange exchange) {
        try {
            ApplicationEvent event = exchange.getIn().getBody(ApplicationEvent.class);
            if (event != null) {
                return event;
            }
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
        return new CamelEvent(this, exchange);
    }
}

