/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpOperationFailedException;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.commons.net.ftp.FTPClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpProducer
extends RemoteFileProducer<RemoteFileExchange> {
    private FtpEndpoint endpoint;
    private FTPClient client;
    private boolean loggedIn;

    public FtpProducer(FtpEndpoint endpoint, FTPClient client) {
        super(endpoint);
        this.endpoint = endpoint;
        this.client = client;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing " + this.endpoint.getConfiguration()));
        }
        try {
            this.connectIfNecessary();
            if (!this.loggedIn) {
                String message = "Could not connect/login to " + this.endpoint.getConfiguration();
                this.log.warn((Object)message);
                throw new FtpOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), message);
            }
            this.process((RemoteFileExchange)this.endpoint.createExchange(exchange));
        }
        catch (Exception e) {
            this.loggedIn = false;
            if (this.isStopping() || this.isStopped()) {
                this.log.warn((Object)("Producer is stopping. Ignoring caught exception: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            }
            this.log.warn((Object)("Exception occured during processing: " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
            this.disconnect();
            throw e;
        }
    }

    @Override
    protected void connectIfNecessary() throws IOException {
        if (!this.client.isConnected() || !this.loggedIn) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not connected/logged in, connecting to " + this.remoteServer()));
            }
            this.loggedIn = FtpUtils.connect(this.client, this.endpoint.getConfiguration());
            if (!this.loggedIn) {
                return;
            }
        }
        this.log.info((Object)("Connected and logged in to " + this.remoteServer()));
    }

    @Override
    public void disconnect() throws IOException {
        this.loggedIn = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Disconnecting from " + this.remoteServer()));
        }
        FtpUtils.disconnect(this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RemoteFileExchange exchange) throws Exception {
        InputStream payload = exchange.getIn().getBody(InputStream.class);
        try {
            boolean success;
            String directory;
            String fileName = this.createFileName(exchange.getIn(), this.endpoint.getConfiguration());
            int lastPathIndex = fileName.lastIndexOf(47);
            if (lastPathIndex != -1 && !FtpUtils.buildDirectory(this.client, directory = fileName.substring(0, lastPathIndex))) {
                this.log.warn((Object)("Couldn't build directory: " + directory + " (could be because of denied permissions)"));
            }
            if (!(success = this.client.storeFile(fileName, payload))) {
                String message = "Error sending file: " + fileName + " to: " + this.remoteServer();
                throw new FtpOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), message);
            }
            this.log.info((Object)("Sent: " + fileName + " to: " + this.remoteServer()));
        }
        finally {
            if (payload != null) {
                payload.close();
            }
        }
    }
}

