/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.ByteArrayOutputStream;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.file.remote.RemoteFileBinding;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileEndpoint<T extends RemoteFileExchange>
extends ScheduledPollEndpoint<T> {
    private RemoteFileBinding binding;
    private RemoteFileConfiguration configuration;

    public RemoteFileEndpoint(String uri, RemoteFileComponent component, RemoteFileConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    protected RemoteFileEndpoint(String endpointUri, RemoteFileConfiguration configuration) {
        super(endpointUri);
        this.configuration = configuration;
    }

    protected RemoteFileEndpoint(String endpointUri) {
        this(endpointUri, new RemoteFileConfiguration());
    }

    protected RemoteFileBinding createRemoteFileBinding() {
        return new RemoteFileBinding();
    }

    @Override
    public T createExchange() {
        return (T)new RemoteFileExchange<RemoteFileBinding>(this.getCamelContext(), this.getExchangePattern(), this.getBinding());
    }

    @Override
    public T createExchange(ExchangePattern pattern) {
        return (T)new RemoteFileExchange<RemoteFileBinding>(this.getCamelContext(), pattern, this.getBinding());
    }

    public T createExchange(String fullFileName, String fileName, long fileLength, ByteArrayOutputStream outputStream) {
        return (T)new RemoteFileExchange<RemoteFileBinding>(this.getCamelContext(), this.getExchangePattern(), this.getBinding(), this.getConfiguration().getHost(), fullFileName, fileName, fileLength, outputStream);
    }

    public RemoteFileBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.createRemoteFileBinding();
        }
        return this.binding;
    }

    public void setBinding(RemoteFileBinding binding) {
        this.binding = binding;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public RemoteFileConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RemoteFileConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getGeneratedFileName(Message message) {
        return this.getFileFriendlyMessageId(message.getMessageId());
    }

    protected String getFileFriendlyMessageId(String id) {
        return UuidGenerator.generateSanitizedId(id);
    }
}

