/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.language.simple.FileLanguage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileProducer<T extends RemoteFileExchange>
extends DefaultProducer<T> {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected RemoteFileEndpoint<T> endpoint;

    protected RemoteFileProducer(RemoteFileEndpoint<T> endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    protected String createFileName(Message message, RemoteFileConfiguration fileConfig) {
        String answer;
        String name = message.getHeader("org.apache.camel.file.name", String.class);
        Expression expression = this.endpoint.getConfiguration().getExpression();
        if (name != null && name.indexOf("${") > -1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("org.apache.camel.file.name contains a FileLanguage expression: " + name));
            }
            expression = FileLanguage.file(name);
        }
        if (expression != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Filename evaluated as expression: " + expression));
            }
            Object result = expression.evaluate(message.getExchange());
            name = message.getExchange().getContext().getTypeConverter().convertTo(String.class, result);
        }
        String endpointFile = fileConfig.getFile();
        if (fileConfig.isDirectory()) {
            String baseDir = "";
            if (endpointFile.length() > 0) {
                baseDir = endpointFile + (endpointFile.endsWith("/") ? "" : "/");
            }
            String fileName = name != null ? name : this.endpoint.getGeneratedFileName(message);
            answer = baseDir + fileName;
        } else {
            answer = endpointFile;
        }
        message.setHeader("org.apache.camel.file.name.produced", answer);
        return answer;
    }

    protected String remoteServer() {
        return this.endpoint.getConfiguration().remoteServerInformation();
    }

    @Override
    protected void doStart() throws Exception {
        this.log.info((Object)"Starting");
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.log.info((Object)"Stopping");
        try {
            this.disconnect();
        }
        catch (Exception e) {
            this.log.warn((Object)("Exception occured during disconecting from " + this.remoteServer() + ". " + e.getClass().getCanonicalName() + " message: " + e.getMessage()));
        }
        super.doStop();
    }

    protected abstract void connectIfNecessary() throws Exception;

    protected abstract void disconnect() throws Exception;
}

