/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Converter;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.http.helper.GZIPHelper;

@Converter
public class HttpConverter {
    @Converter
    public HttpServletRequest toServletRequest(HttpMessage message) {
        if (message == null) {
            return null;
        }
        return message.getRequest();
    }

    @Converter
    public ServletInputStream toServletInputStream(HttpMessage message) throws IOException {
        HttpServletRequest request = this.toServletRequest(message);
        if (request != null) {
            return request.getInputStream();
        }
        return null;
    }

    @Converter
    public InputStream toInputStream(HttpMessage message) throws Exception {
        HttpServletRequest request = this.toServletRequest(message);
        if (request != null) {
            return GZIPHelper.getInputStream(request);
        }
        return null;
    }

    @Converter
    public BufferedReader toReader(HttpMessage message) throws IOException {
        HttpServletRequest request = this.toServletRequest(message);
        if (request != null) {
            return request.getReader();
        }
        return null;
    }
}

