/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.protocol.NHttpServiceHandlerBase;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.nio.util.SimpleOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EncodingUtils;

public class BufferingHttpServiceHandler
extends NHttpServiceHandlerBase
implements NHttpServiceHandler {
    public BufferingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, ByteBufferAllocator allocator, HttpParams params) {
        super(httpProcessor, responseFactory, connStrategy, allocator, params);
    }

    public BufferingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, HttpParams params) {
        this(httpProcessor, responseFactory, connStrategy, (ByteBufferAllocator)new HeapByteBufferAllocator(), params);
    }

    public void connected(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        ServerConnState connState = new ServerConnState(this.allocator);
        context.setAttribute("http.nio.conn-state", (Object)connState);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen((NHttpConnection)conn);
        }
    }

    public void requestReceived(NHttpServerConnection conn) {
        block11: {
            HttpContext context = conn.getContext();
            HttpRequest request = conn.getHttpRequest();
            request.setParams(this.params);
            ServerConnState connState = (ServerConnState)context.getAttribute("http.nio.conn-state");
            connState.resetInput();
            connState.setRequest(request);
            connState.setInputState(1);
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                ver = HttpVersion.HTTP_1_1;
            }
            try {
                if (request instanceof HttpEntityEnclosingRequest) {
                    if (!((HttpEntityEnclosingRequest)request).expectContinue()) break block11;
                    HttpResponse response = this.responseFactory.newHttpResponse(ver, 100, context);
                    request.setParams(this.params);
                    if (this.expectationVerifier != null) {
                        try {
                            this.expectationVerifier.verify(request, response, context);
                        }
                        catch (HttpException ex) {
                            response = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, context);
                            request.setParams(this.params);
                            this.handleException(ex, response);
                        }
                    }
                    if (response.getStatusLine().getStatusCode() < 200) {
                        conn.submitResponse(response);
                    } else {
                        conn.resetInput();
                        connState.resetInput();
                        this.sendResponse(conn, response);
                    }
                    break block11;
                }
                conn.suspendInput();
                this.processRequest(conn, request);
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, ex);
                if (this.eventListener == null) break block11;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    public void closed(NHttpServerConnection conn) {
        if (this.eventListener != null) {
            this.eventListener.connectionClosed((NHttpConnection)conn);
        }
    }

    public void exception(NHttpServerConnection conn, HttpException httpex) {
        block4: {
            HttpContext context = conn.getContext();
            try {
                HttpResponse response = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, context);
                response.setParams(this.params);
                this.handleException(httpex, response);
                response.setEntity(null);
                this.sendResponse(conn, response);
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, ex);
                if (this.eventListener == null) break block4;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        block6: {
            HttpContext context = conn.getContext();
            HttpRequest request = conn.getHttpRequest();
            ServerConnState connState = (ServerConnState)context.getAttribute("http.nio.conn-state");
            ContentInputBuffer buffer = connState.getInbuffer();
            connState.setInputState(2);
            try {
                buffer.consumeContent(decoder);
                if (decoder.isCompleted()) {
                    connState.setInputState(4);
                    HttpEntityEnclosingRequest entityReq = (HttpEntityEnclosingRequest)request;
                    if (entityReq.getEntity() != null) {
                        entityReq.setEntity((HttpEntity)new ContentBufferEntity(entityReq.getEntity(), connState.getInbuffer()));
                    }
                    conn.suspendInput();
                    this.processRequest(conn, request);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, ex);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    public void responseReady(NHttpServerConnection conn) {
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        block5: {
            HttpContext context = conn.getContext();
            HttpResponse response = conn.getHttpResponse();
            ServerConnState connState = (ServerConnState)context.getAttribute("http.nio.conn-state");
            ContentOutputBuffer buffer = connState.getOutbuffer();
            connState.setOutputState(16);
            try {
                buffer.produceContent(encoder);
                if (encoder.isCompleted()) {
                    connState.setOutputState(32);
                    connState.resetOutput();
                    if (!this.connStrategy.keepAlive(response, context)) {
                        conn.close();
                    } else {
                        conn.requestInput();
                    }
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, ex);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
            }
        }
    }

    protected void handleException(HttpException ex, HttpResponse response) {
        int code = 500;
        if (ex instanceof MethodNotSupportedException) {
            code = 501;
        } else if (ex instanceof UnsupportedHttpVersionException) {
            code = 505;
        } else if (ex instanceof ProtocolException) {
            code = 400;
        }
        response.setStatusCode(code);
        byte[] msg = EncodingUtils.getAsciiBytes((String)ex.getMessage());
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response.setEntity((HttpEntity)entity);
    }

    protected void processRequest(NHttpServerConnection conn, HttpRequest request) throws IOException, HttpException {
        HttpContext context = conn.getContext();
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        HttpResponse response = this.responseFactory.newHttpResponse(ver, 200, conn.getContext());
        request.setParams(this.params);
        context.setAttribute("http.request", (Object)request);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.response", (Object)response);
        try {
            this.httpProcessor.process(request, context);
            HttpRequestHandler handler = null;
            if (this.handlerResolver != null) {
                String requestURI = request.getRequestLine().getUri();
                handler = this.handlerResolver.lookup(requestURI);
            }
            if (handler != null) {
                handler.handle(request, response, context);
            } else {
                response.setStatusCode(501);
            }
        }
        catch (HttpException ex) {
            response = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, context);
            request.setParams(this.params);
            this.handleException(ex, response);
        }
        this.sendResponse(conn, response);
    }

    protected void sendResponse(NHttpServerConnection conn, HttpResponse response) throws IOException, HttpException {
        HttpContext context = conn.getContext();
        ServerConnState connState = (ServerConnState)context.getAttribute("http.nio.conn-state");
        ContentOutputBuffer buffer = connState.getOutbuffer();
        this.httpProcessor.process(response, context);
        if (!this.canResponseHaveBody(connState.getRequest(), response)) {
            response.setEntity(null);
        }
        conn.submitResponse(response);
        connState.setOutputState(8);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ContentOutputStream outstream = new ContentOutputStream(buffer);
            entity.writeTo((OutputStream)outstream);
            outstream.flush();
            outstream.close();
        } else {
            connState.resetOutput();
            if (!this.connStrategy.keepAlive(response, context)) {
                conn.close();
            } else {
                conn.requestInput();
            }
        }
    }

    static class ServerConnState {
        public static final int READY = 0;
        public static final int REQUEST_RECEIVED = 1;
        public static final int REQUEST_BODY_STREAM = 2;
        public static final int REQUEST_BODY_DONE = 4;
        public static final int RESPONSE_SENT = 8;
        public static final int RESPONSE_BODY_STREAM = 16;
        public static final int RESPONSE_BODY_DONE = 32;
        private SimpleInputBuffer inbuffer;
        private ContentOutputBuffer outbuffer;
        private int inputState = 0;
        private int outputState = 0;
        private HttpRequest request;
        private final ByteBufferAllocator allocator;

        public ServerConnState(ByteBufferAllocator allocator) {
            this.allocator = allocator;
        }

        public ContentInputBuffer getInbuffer() {
            if (this.inbuffer == null) {
                this.inbuffer = new SimpleInputBuffer(2048, this.allocator);
            }
            return this.inbuffer;
        }

        public ContentOutputBuffer getOutbuffer() {
            if (this.outbuffer == null) {
                this.outbuffer = new SimpleOutputBuffer(2048, this.allocator);
            }
            return this.outbuffer;
        }

        public int getInputState() {
            return this.inputState;
        }

        public void setInputState(int inputState) {
            this.inputState = inputState;
        }

        public int getOutputState() {
            return this.outputState;
        }

        public void setOutputState(int outputState) {
            this.outputState = outputState;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public void resetInput() {
            this.inbuffer = null;
            this.request = null;
            this.inputState = 0;
        }

        public void resetOutput() {
            this.outbuffer = null;
            this.outputState = 0;
        }
    }
}

