/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.HeaderFilterStrategyAware;
import org.apache.camel.component.jhc.JhcEndpoint;
import org.apache.camel.component.jhc.JhcExchange;
import org.apache.camel.component.jhc.JhcHeaderFilterStrategy;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JhcComponent
extends DefaultComponent<JhcExchange>
implements HeaderFilterStrategyAware {
    private static final Log LOG = LogFactory.getLog(JhcComponent.class);
    private HttpParams params;
    private HeaderFilterStrategy headerFilterStrategy;

    public JhcComponent() {
        this.setHeaderFilterStrategy(new JhcHeaderFilterStrategy());
        this.params = new BasicHttpParams().setIntParameter("http.socket.timeout", 5000).setIntParameter("http.connection.timeout", 10000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.useragent", (Object)"Camel-JhcComponent/1.1");
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }

    @Override
    protected Endpoint<JhcExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        return new JhcEndpoint(uri, this, new URI(uri.substring(uri.indexOf(58) + 1)));
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

