/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class EndpointMessageListener
implements MessageListener {
    private static final transient Log LOG = LogFactory.getLog(EndpointMessageListener.class);
    private JmsEndpoint endpoint;
    private Processor processor;
    private JmsBinding binding;
    private boolean eagerLoadingOfProperties;
    private Destination replyToDestination;
    private JmsOperations template;
    private boolean disableReplyTo;

    public EndpointMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
        endpoint.getConfiguration().configure(this);
    }

    public void onMessage(Message message) {
        RuntimeCamelException rce = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.endpoint + " consumer receiving JMS message: " + message));
            }
            Destination replyDestination = this.getReplyToDestination(message);
            JmsExchange exchange = this.createExchange(message, replyDestination);
            if (this.eagerLoadingOfProperties) {
                exchange.getIn().getHeaders();
            }
            this.processor.process(exchange);
            JmsMessage body = null;
            if (exchange.isFailed()) {
                if (exchange.getException() != null) {
                    rce = ObjectHelper.wrapRuntimeCamelException(exchange.getException());
                } else if (exchange.getFault().getBody() != null) {
                    body = exchange.getFault();
                }
            } else {
                body = exchange.getOut(false);
            }
            if (rce == null && body != null && !this.disableReplyTo) {
                this.sendReply(replyDestination, message, exchange, body);
            }
        }
        catch (Exception e) {
            rce = ObjectHelper.wrapRuntimeCamelException(e);
        }
        if (rce != null) {
            LOG.warn((Object)(this.endpoint + " consumer caught an exception while processing " + "JMS message: " + message), (Throwable)rce);
            throw rce;
        }
    }

    public JmsExchange createExchange(Message message, Destination replyDestination) {
        JmsExchange exchange = new JmsExchange(this.endpoint.getCamelContext(), this.endpoint.getExchangePattern(), this.getBinding(), message);
        if (replyDestination != null && !this.disableReplyTo) {
            exchange.setProperty("org.apache.camel.jms.replyDestination", replyDestination);
            exchange.setPattern(ExchangePattern.InOut);
        }
        return exchange;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding(this.endpoint);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public boolean isEagerLoadingOfProperties() {
        return this.eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }

    public synchronized JmsOperations getTemplate() {
        if (this.template == null) {
            this.template = this.endpoint.createInOnlyTemplate();
        }
        return this.template;
    }

    public void setTemplate(JmsOperations template) {
        this.template = template;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public Destination getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setReplyToDestination(Destination replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    protected void sendReply(Destination replyDestination, final Message message, final JmsExchange exchange, final JmsMessage out) {
        if (replyDestination == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot send reply message as there is no replyDestination for: " + out));
            }
            return;
        }
        this.getTemplate().send(replyDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message reply = EndpointMessageListener.this.endpoint.getBinding().makeJmsMessage(exchange, out, session);
                if (EndpointMessageListener.this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID()) {
                    String messageID = exchange.getIn().getHeader("JMSMessageID", String.class);
                    reply.setJMSCorrelationID(messageID);
                } else {
                    String correlationID = message.getJMSCorrelationID();
                    if (correlationID != null) {
                        reply.setJMSCorrelationID(correlationID);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(EndpointMessageListener.this.endpoint + " sending reply JMS message: " + reply));
                }
                return reply;
            }
        });
    }

    protected Destination getReplyToDestination(Message message) throws JMSException {
        Destination destination = this.replyToDestination;
        if (destination == null) {
            destination = message.getJMSReplyTo();
        }
        return destination;
    }
}

